/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.testing.Assertions;
import com.facebook.drift.TApplicationException;
import com.facebook.drift.TException;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.builtin.VoidThriftCodec;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.transport.MethodMetadata;
import com.facebook.drift.transport.ParameterMetadata;
import com.facebook.drift.transport.client.InvokeRequest;
import com.facebook.drift.transport.netty.buffer.TestingPooledByteBufAllocator;
import com.facebook.drift.transport.netty.client.ConnectionManager;
import com.facebook.drift.transport.netty.client.DriftNettyClientConfig;
import com.facebook.drift.transport.netty.client.DriftNettyMethodInvoker;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.scribe.apache.LogEntry;
import com.facebook.drift.transport.netty.scribe.apache.ResultCode;
import com.facebook.drift.transport.netty.scribe.apache.ScribeService;
import com.facebook.drift.transport.netty.scribe.apache.scribe;
import com.facebook.drift.transport.netty.scribe.drift.DriftLogEntry;
import com.facebook.drift.transport.netty.scribe.drift.DriftResultCode;
import com.facebook.drift.transport.netty.server.DriftNettyServerConfig;
import com.facebook.drift.transport.netty.server.DriftNettyServerTransport;
import com.facebook.drift.transport.netty.server.DriftNettyServerTransportFactory;
import com.facebook.drift.transport.server.ServerInvokeRequest;
import com.facebook.drift.transport.server.ServerMethodInvoker;
import com.facebook.drift.transport.server.ServerTransport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.Future;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.apache.thrift.TProcessor;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDriftNettyMethodInvoker {
    private static final ThriftCodecManager CODEC_MANAGER = new ThriftCodecManager(new ThriftCodec[0]);
    private static final MethodMetadata LOG_METHOD_METADATA = new MethodMetadata("Log", (List)ImmutableList.of((Object)new ParameterMetadata(1, "messages", CODEC_MANAGER.getCodec(ThriftType.list((ThriftType)CODEC_MANAGER.getCodec(DriftLogEntry.class).getType())))), CODEC_MANAGER.getCodec(DriftResultCode.class), (Map)ImmutableMap.of(), false, true);
    private static final List<LogEntry> MESSAGES = ImmutableList.of((Object)new LogEntry("hello", "world"), (Object)new LogEntry("bye", "world"));
    private static final List<DriftLogEntry> DRIFT_MESSAGES = ImmutableList.copyOf((Collection)MESSAGES.stream().map(input -> new DriftLogEntry(input.category, input.message)).collect(Collectors.toList()));
    private static final DriftResultCode DRIFT_OK = DriftResultCode.OK;

    @Test
    public void testThriftService() throws Exception {
        ScribeService scribeService = new ScribeService();
        scribe.Processor<ScribeService> processor = new scribe.Processor<ScribeService>(scribeService);
        List<LogEntry> expectedMessages = TestDriftNettyMethodInvoker.testProcessor(processor);
        Assert.assertEquals(scribeService.getMessages(), expectedMessages);
    }

    private static List<LogEntry> testProcessor(TProcessor processor) throws Exception {
        int invocationCount = TestDriftNettyMethodInvoker.testProcessor(processor, (List<ToIntFunction<HostAndPort>>)ImmutableList.of(address -> TestDriftNettyMethodInvoker.logThrift(address, MESSAGES, (TTransportFactory)new TFramedTransport.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory()), address -> TestDriftNettyMethodInvoker.logThriftAsync(address, MESSAGES), address -> TestDriftNettyMethodInvoker.logNiftyInvocationHandlerOptional(address, DRIFT_MESSAGES), address -> TestDriftNettyMethodInvoker.logNiftyInvocationHandler(address, DRIFT_MESSAGES, Transport.FRAMED, Protocol.BINARY)));
        return Lists.newArrayList((Iterable)Iterables.concat(Collections.nCopies(invocationCount, MESSAGES)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int testProcessor(TProcessor processor, List<ToIntFunction<HostAndPort>> clients) throws Exception {
        Throwable throwable = null;
        try (TServerSocket serverTransport = new TServerSocket(0);){
            int n;
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            TFramedTransport.Factory transportFactory = new TFramedTransport.Factory();
            TThreadPoolServer server = new TThreadPoolServer((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).protocolFactory((TProtocolFactory)protocolFactory)).transportFactory((TTransportFactory)transportFactory)).processor(processor));
            Thread serverThread = new Thread(() -> ((TServer)server).serve());
            try {
                serverThread.start();
                int localPort = serverTransport.getServerSocket().getLocalPort();
                HostAndPort address = HostAndPort.fromParts((String)"localhost", (int)localPort);
                int sum = 0;
                for (ToIntFunction<HostAndPort> client : clients) {
                    sum += client.applyAsInt(address);
                }
                n = sum;
            }
            catch (Throwable throwable2) {
                try {
                    server.stop();
                    serverThread.interrupt();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            server.stop();
            serverThread.interrupt();
            return n;
        }
    }

    @Test
    public void testDriftNettyService() {
        TestServerMethodInvoker methodInvoker = new TestServerMethodInvoker();
        List<DriftLogEntry> expectedMessages = TestDriftNettyMethodInvoker.testMethodInvoker(methodInvoker);
        Assert.assertEquals((Collection)ImmutableList.copyOf((Collection)methodInvoker.getMessages()), expectedMessages);
    }

    private static List<DriftLogEntry> testMethodInvoker(ServerMethodInvoker methodInvoker) {
        int invocationCount = TestDriftNettyMethodInvoker.testMethodInvoker(methodInvoker, (List<ToIntFunction<HostAndPort>>)ImmutableList.of(address -> TestDriftNettyMethodInvoker.logThrift(address, MESSAGES, new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory()), address -> TestDriftNettyMethodInvoker.logThrift(address, MESSAGES, new TTransportFactory(), (TProtocolFactory)new TCompactProtocol.Factory()), address -> TestDriftNettyMethodInvoker.logThrift(address, MESSAGES, (TTransportFactory)new TFramedTransport.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory()), address -> TestDriftNettyMethodInvoker.logThrift(address, MESSAGES, (TTransportFactory)new TFramedTransport.Factory(), (TProtocolFactory)new TCompactProtocol.Factory()), address -> TestDriftNettyMethodInvoker.logThriftAsync(address, MESSAGES), address -> TestDriftNettyMethodInvoker.logNiftyInvocationHandler(address, DRIFT_MESSAGES, Transport.UNFRAMED, Protocol.BINARY), address -> TestDriftNettyMethodInvoker.logNiftyInvocationHandler(address, DRIFT_MESSAGES, Transport.UNFRAMED, Protocol.COMPACT), address -> TestDriftNettyMethodInvoker.logNiftyInvocationHandler(address, DRIFT_MESSAGES, Transport.UNFRAMED, Protocol.FB_COMPACT), address -> TestDriftNettyMethodInvoker.logNiftyInvocationHandler(address, DRIFT_MESSAGES, Transport.FRAMED, Protocol.BINARY), address -> TestDriftNettyMethodInvoker.logNiftyInvocationHandler(address, DRIFT_MESSAGES, Transport.FRAMED, Protocol.COMPACT), address -> TestDriftNettyMethodInvoker.logNiftyInvocationHandler(address, DRIFT_MESSAGES, Transport.FRAMED, Protocol.FB_COMPACT), address -> TestDriftNettyMethodInvoker.logNiftyInvocationHandler(address, DRIFT_MESSAGES, Transport.HEADER, Protocol.BINARY), (Object[])new ToIntFunction[]{address -> TestDriftNettyMethodInvoker.logNiftyInvocationHandler(address, DRIFT_MESSAGES, Transport.HEADER, Protocol.FB_COMPACT)}));
        return Lists.newArrayList((Iterable)Iterables.concat(Collections.nCopies(invocationCount, DRIFT_MESSAGES)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int testMethodInvoker(ServerMethodInvoker methodInvoker, List<ToIntFunction<HostAndPort>> clients) {
        TestingPooledByteBufAllocator testingAllocator = new TestingPooledByteBufAllocator();
        ServerTransport serverTransport = new DriftNettyServerTransportFactory(new DriftNettyServerConfig(), (ByteBufAllocator)testingAllocator).createServerTransport(methodInvoker);
        try {
            serverTransport.start();
            HostAndPort address = HostAndPort.fromParts((String)"localhost", (int)((DriftNettyServerTransport)serverTransport).getPort());
            int sum = 0;
            for (ToIntFunction<HostAndPort> client : clients) {
                sum += client.applyAsInt(address);
            }
            int n = sum;
            return n;
        }
        finally {
            serverTransport.shutdown();
            testingAllocator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int logThrift(HostAndPort address, List<LogEntry> messages, TTransportFactory framingFactory, TProtocolFactory protocolFactory) {
        try {
            socket.open();
            try (TSocket socket = new TSocket(address.getHost(), address.getPort());){
                TProtocol tp = protocolFactory.getProtocol(framingFactory.getTransport((TTransport)socket));
                scribe.Client client = new scribe.Client(tp);
                Assert.assertEquals((Object)((Object)client.Log(messages)), (Object)((Object)ResultCode.OK));
                try {
                    client.Log((List<LogEntry>)ImmutableList.of((Object)new LogEntry("exception", "test")));
                    Assert.fail((String)"Expected exception");
                }
                catch (org.apache.thrift.TApplicationException e) {
                    Assert.assertEquals((int)e.getType(), (int)10);
                }
            }
        }
        catch (org.apache.thrift.TException e) {
            throw new RuntimeException(e);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int logThriftAsync(HostAndPort address, List<LogEntry> messages) {
        try {
            TAsyncClientManager asyncClientManager = new TAsyncClientManager();
            try (TNonblockingSocket socket = new TNonblockingSocket(address.getHost(), address.getPort());){
                scribe.AsyncClient client = new scribe.AsyncClient((TProtocolFactory)new TBinaryProtocol.Factory(), asyncClientManager, (TNonblockingTransport)socket);
                final SettableFuture futureResult = SettableFuture.create();
                client.Log(messages, new AsyncMethodCallback<ResultCode>(){

                    public void onComplete(ResultCode resultCode) {
                        try {
                            futureResult.set((Object)resultCode);
                        }
                        catch (Throwable exception) {
                            futureResult.setException(exception);
                        }
                    }

                    public void onError(Exception exception) {
                        futureResult.setException((Throwable)exception);
                    }
                });
                Assert.assertEquals((Object)futureResult.get(), (Object)((Object)ResultCode.OK));
            }
            finally {
                asyncClientManager.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 1;
    }

    /*
     * Exception decompiling
     */
    private static int logNiftyInvocationHandler(HostAndPort address, List<DriftLogEntry> entries, Transport transport, Protocol protocol) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeout() throws Exception {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"test-timeout"));
        DriftNettyMethodInvoker invoker = new DriftNettyMethodInvoker(new ConnectionManager.ConnectionParameters(Transport.FRAMED, Protocol.BINARY, new DataSize(16.0, DataSize.Unit.MEGABYTE), new Duration(11.0, TimeUnit.MILLISECONDS), new Duration(13.0, TimeUnit.MILLISECONDS), Optional.empty(), Optional.empty(), false, false), (ConnectionManager)new HangingConnectionManager(), executor, new Duration(17.0, TimeUnit.MILLISECONDS));
        ListenableFuture response = invoker.invoke(new InvokeRequest(new MethodMetadata("test", (List)ImmutableList.of(), (ThriftCodec)new VoidThriftCodec(), (Map)ImmutableMap.of(), false, true), () -> HostAndPort.fromParts((String)"localhost", (int)1234), (Map)ImmutableMap.of(), (List)ImmutableList.of()));
        try {
            response.get();
            Assert.fail((String)"expected exception");
        }
        catch (ExecutionException e) {
            Assertions.assertInstanceOf((Object)e.getCause(), TException.class);
            Assert.assertEquals((String)e.getCause().getMessage(), (String)"Invocation response future did not complete after 41.00ms");
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * Exception decompiling
     */
    private static int logNiftyInvocationHandlerOptional(HostAndPort address, List<DriftLogEntry> entries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ HostAndPort lambda$logNiftyInvocationHandlerOptional$25(HostAndPort address) {
        return address;
    }

    private static /* synthetic */ HostAndPort lambda$logNiftyInvocationHandlerOptional$24(HostAndPort address) {
        return address;
    }

    private static /* synthetic */ HostAndPort lambda$logNiftyInvocationHandlerOptional$23(HostAndPort address) {
        return address;
    }

    private static /* synthetic */ DriftNettyClientConfig lambda$logNiftyInvocationHandlerOptional$22(DriftNettyClientConfig config, Void clientIdentity) {
        return config;
    }

    private static /* synthetic */ HostAndPort lambda$logNiftyInvocationHandler$20(HostAndPort address) {
        return address;
    }

    private static /* synthetic */ HostAndPort lambda$logNiftyInvocationHandler$19(HostAndPort address) {
        return address;
    }

    private static /* synthetic */ DriftNettyClientConfig lambda$logNiftyInvocationHandler$18(DriftNettyClientConfig config, Void clientIdentity) {
        return config;
    }

    private static class TestServerMethodInvoker
    implements ServerMethodInvoker {
        private final List<DriftLogEntry> messages = new CopyOnWriteArrayList<DriftLogEntry>();

        private TestServerMethodInvoker() {
        }

        private List<DriftLogEntry> getMessages() {
            return this.messages;
        }

        public Optional<MethodMetadata> getMethodMetadata(String name) {
            if (LOG_METHOD_METADATA.getName().equals(name)) {
                return Optional.of(LOG_METHOD_METADATA);
            }
            return Optional.empty();
        }

        public ListenableFuture<Object> invoke(ServerInvokeRequest request) {
            MethodMetadata method = request.getMethod();
            if (!LOG_METHOD_METADATA.getName().equals(method.getName())) {
                return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("unknown method " + method));
            }
            Map parameters = request.getParameters();
            if (parameters.size() != 1 || !parameters.containsKey((short)1) || !(Iterables.getOnlyElement(parameters.values()) instanceof List)) {
                return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("invalid parameters"));
            }
            List messages = (List)Iterables.getOnlyElement(parameters.values());
            for (DriftLogEntry message : messages) {
                if (!message.getCategory().equals("exception")) continue;
                return Futures.immediateFailedFuture((Throwable)new TApplicationException(TApplicationException.Type.UNSUPPORTED_CLIENT_TYPE, message.getMessage()));
            }
            this.messages.addAll(messages);
            return Futures.immediateFuture((Object)((Object)DRIFT_OK));
        }

        public void recordResult(String methodName, long startTime, ListenableFuture<Object> result) {
        }
    }

    private static class HangingConnectionManager
    implements ConnectionManager {
        private HangingConnectionManager() {
        }

        public Future<Channel> getConnection(ConnectionManager.ConnectionParameters connectionParameters, HostAndPort address) {
            return new DefaultEventExecutor().newPromise();
        }

        public void returnConnection(Channel connection) {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }
}

