/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.drift.TException;
import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.protocol.TMessage;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.drift.transport.netty.buffer.TestingPooledByteBufAllocator;
import com.facebook.drift.transport.netty.codec.FrameInfo;
import com.facebook.drift.transport.netty.codec.HeaderTransport;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.ThriftFrame;
import com.facebook.drift.transport.netty.codec.ThriftHeaderTransform;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.ssl.TChannelBufferOutputTransport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHeaderTransport {
    private static final int FULL_LENGTH = -1;
    private String bigString;

    @BeforeClass
    void setup() throws IOException {
        this.bigString = Resources.toString((URL)Resources.getResource((String)"TestHeaderTransport.txt"), (Charset)StandardCharsets.UTF_8);
    }

    @Test
    public void testNoTransform() throws Exception {
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of(), 0, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of(), 1, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of(), 5, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of(), 10, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of(), 15, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of(), 50, Optional.of(new FrameInfo("method", 1, 65450, Transport.HEADER, Protocol.BINARY, true)));
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of(), 100, Optional.of(new FrameInfo("method", 1, 65450, Transport.HEADER, Protocol.BINARY, true)));
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of(), -1, Optional.of(new FrameInfo("method", 1, 65450, Transport.HEADER, Protocol.BINARY, true)));
        this.assertRoundTrip((List<ThriftHeaderTransform>)ImmutableList.of());
    }

    @Test
    public void testZlibTransform() throws Exception {
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of((Object)ThriftHeaderTransform.ZLIB_TRANSFORM), 0, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of((Object)ThriftHeaderTransform.ZLIB_TRANSFORM), 1, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of((Object)ThriftHeaderTransform.ZLIB_TRANSFORM), 5, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of((Object)ThriftHeaderTransform.ZLIB_TRANSFORM), 10, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of((Object)ThriftHeaderTransform.ZLIB_TRANSFORM), 15, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of((Object)ThriftHeaderTransform.ZLIB_TRANSFORM), 50, Optional.empty());
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of((Object)ThriftHeaderTransform.ZLIB_TRANSFORM), 100, Optional.of(new FrameInfo("method", 1, 65450, Transport.HEADER, Protocol.BINARY, true)));
        this.assertTryDecodeSequenceId((List<ThriftHeaderTransform>)ImmutableList.of((Object)ThriftHeaderTransform.ZLIB_TRANSFORM), -1, Optional.of(new FrameInfo("method", 1, 65450, Transport.HEADER, Protocol.BINARY, true)));
        this.assertRoundTrip((List<ThriftHeaderTransform>)ImmutableList.of((Object)ThriftHeaderTransform.ZLIB_TRANSFORM));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertTryDecodeSequenceId(List<ThriftHeaderTransform> transforms, int length, Optional<FrameInfo> expected) throws Exception {
        try (TestingPooledByteBufAllocator allocator = new TestingPooledByteBufAllocator();){
            ByteBuf message = this.createTestFrame((ByteBufAllocator)allocator, "method", (byte)1, 65450, Protocol.BINARY, true, transforms);
            try {
                if (length >= 0) {
                    TestHeaderTransport.assertDecodeFrameInfo((ByteBufAllocator)allocator, message.retainedSlice(0, length), expected);
                } else {
                    TestHeaderTransport.assertDecodeFrameInfo((ByteBufAllocator)allocator, message.retainedDuplicate(), expected);
                }
            }
            finally {
                message.release();
            }
            TestHeaderTransport.assertDecodeFrameInfo((ByteBufAllocator)allocator, this.createTestFrame((ByteBufAllocator)allocator, "method1", (byte)4, 123, Protocol.FB_COMPACT, false, transforms), Optional.of(new FrameInfo("method1", 4, 123, Transport.HEADER, Protocol.FB_COMPACT, false)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertRoundTrip(List<ThriftHeaderTransform> transforms) throws Exception {
        try (TestingPooledByteBufAllocator allocator = new TestingPooledByteBufAllocator();){
            ByteBuf expected = this.createTestMessage((ByteBufAllocator)allocator, "method", (byte)1, 65450, Protocol.BINARY);
            ByteBuf message = this.createTestFrame((ByteBufAllocator)allocator, "method", (byte)1, 65450, Protocol.BINARY, true, transforms);
            try {
                Assert.assertEquals((int)message.readerIndex(), (int)0);
                ThriftFrame result = HeaderTransport.decodeFrame((ByteBufAllocator)allocator, (ByteBuf)message.retainedDuplicate());
                ByteBuf resultBody = result.getMessage();
                byte[] a = new byte[expected.readableBytes()];
                byte[] b = new byte[resultBody.readableBytes()];
                expected.readBytes(a);
                resultBody.readBytes(b);
                expected.resetReaderIndex();
                resultBody.resetReaderIndex();
                Assert.assertTrue((expected.compareTo(resultBody) == 0 ? 1 : 0) != 0);
                resultBody.release();
                result.release();
            }
            finally {
                message.release();
                expected.release();
            }
        }
    }

    private static void assertDecodeFrameInfo(ByteBufAllocator bufAllocator, ByteBuf message, Optional<FrameInfo> frameInfo) {
        try {
            Assert.assertEquals((Object)HeaderTransport.tryDecodeFrameInfo((ByteBufAllocator)bufAllocator, (ByteBuf)message), frameInfo);
        }
        finally {
            message.release();
        }
    }

    private ByteBuf createTestFrame(ByteBufAllocator allocator, String methodName, byte messageType, int sequenceId, Protocol protocol, boolean supportOutOfOrderResponse, List<ThriftHeaderTransform> transforms) throws TException {
        ThriftFrame frame = new ThriftFrame(sequenceId, this.createTestMessage(allocator, methodName, messageType, sequenceId, protocol), (Map)ImmutableMap.of((Object)"header", (Object)"value"), transforms, Transport.HEADER, protocol, supportOutOfOrderResponse);
        return HeaderTransport.encodeFrame((ByteBufAllocator)allocator, (ThriftFrame)frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf createTestMessage(ByteBufAllocator allocator, String methodName, byte messageType, int sequenceId, Protocol protocol) throws TException {
        TChannelBufferOutputTransport transport = new TChannelBufferOutputTransport(allocator);
        try {
            TProtocol protocolWriter = protocol.createProtocol((TTransport)transport);
            protocolWriter.writeMessageBegin(new TMessage(methodName, messageType, sequenceId));
            ProtocolWriter writer = new ProtocolWriter((TProtocolWriter)protocolWriter);
            writer.writeStructBegin("method_args");
            writer.writeStructEnd();
            writer.writeStructBegin("a_very_long_string");
            writer.writeString(this.bigString);
            writer.writeStructEnd();
            protocolWriter.writeMessageEnd();
            ByteBuf byteBuf = transport.getBuffer();
            return byteBuf;
        }
        finally {
            transport.release();
        }
    }
}

