/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.drift.TException;
import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.protocol.TMessage;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.drift.transport.netty.buffer.TestingPooledByteBufAllocator;
import com.facebook.drift.transport.netty.codec.FrameInfo;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.SimpleFrameInfoDecoder;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.ssl.TChannelBufferOutputTransport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimpleFrameInfoDecoder {
    private static final String METHOD_NAME = "method";
    private static final int SEQUENCE_ID = -1430532882;

    @Test
    public void testDecodeSequenceId() throws Exception {
        try (TestingPooledByteBufAllocator allocator = new TestingPooledByteBufAllocator();){
            for (Protocol protocol : Protocol.values()) {
                TestSimpleFrameInfoDecoder.testDecodeSequenceId((ByteBufAllocator)allocator, protocol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testDecodeSequenceId(ByteBufAllocator allocator, Protocol protocol) throws TException {
        SimpleFrameInfoDecoder decoder = new SimpleFrameInfoDecoder(Transport.FRAMED, protocol, true);
        ByteBuf message = TestSimpleFrameInfoDecoder.createTestMessage(allocator, protocol);
        try {
            Assert.assertFalse((boolean)decoder.tryDecodeFrameInfo(allocator, message.slice(0, 0)).isPresent());
            Assert.assertFalse((boolean)decoder.tryDecodeFrameInfo(allocator, message.slice(0, 1)).isPresent());
            Assert.assertFalse((boolean)decoder.tryDecodeFrameInfo(allocator, message.slice(0, 2)).isPresent());
            Assert.assertFalse((boolean)decoder.tryDecodeFrameInfo(allocator, message.slice(0, 5)).isPresent());
            Assert.assertTrue((boolean)decoder.tryDecodeFrameInfo(allocator, message.slice(0, message.readableBytes())).isPresent());
            Assert.assertTrue((boolean)decoder.tryDecodeFrameInfo(allocator, message).isPresent());
            Assert.assertEquals(decoder.tryDecodeFrameInfo(allocator, message).get(), (Object)new FrameInfo(METHOD_NAME, 1, -1430532882, Transport.FRAMED, protocol, true));
        }
        finally {
            message.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuf createTestMessage(ByteBufAllocator allocator, Protocol protocol) throws TException {
        TChannelBufferOutputTransport transport = new TChannelBufferOutputTransport(allocator);
        try {
            TProtocol protocolWriter = protocol.createProtocol((TTransport)transport);
            protocolWriter.writeMessageBegin(new TMessage(METHOD_NAME, 1, -1430532882));
            ProtocolWriter writer = new ProtocolWriter((TProtocolWriter)protocolWriter);
            writer.writeStructBegin("method_args");
            writer.writeStructEnd();
            protocolWriter.writeMessageEnd();
            ByteBuf byteBuf = transport.getBuffer();
            return byteBuf;
        }
        finally {
            transport.release();
        }
    }
}

