/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.protocol.TMessage;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.drift.transport.netty.buffer.TestingPooledByteBufAllocator;
import com.facebook.drift.transport.netty.codec.FrameInfo;
import com.facebook.drift.transport.netty.codec.FrameInfoDecoder;
import com.facebook.drift.transport.netty.codec.FrameTooLargeException;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.SimpleFrameInfoDecoder;
import com.facebook.drift.transport.netty.codec.ThriftFramedDecoder;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.ssl.TChannelBufferOutputTransport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftFramedDecoder {
    @Test
    public void testBelowLimit() {
        byte[] first = new byte[]{1, 2, 3, 4, 5};
        byte[] second = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] third = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        try (TestingPooledByteBufAllocator allocator = new TestingPooledByteBufAllocator();){
            ByteBuf buffer = allocator.buffer(1024);
            TestThriftFramedDecoder.writeLengthPrefixedFrame(buffer, first);
            TestThriftFramedDecoder.writeLengthPrefixedFrame(buffer, second);
            TestThriftFramedDecoder.writeLengthPrefixedFrame(buffer, third);
            ThriftFramedDecoder decoder = TestThriftFramedDecoder.createDecoder(third.length);
            ByteBuf decodedFirst = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNotNull((Object)decodedFirst);
            TestThriftFramedDecoder.assertContentEquals(decodedFirst, first);
            decodedFirst.release();
            ByteBuf decodedSecond = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNotNull((Object)decodedSecond);
            TestThriftFramedDecoder.assertContentEquals(decodedSecond, second);
            decodedSecond.release();
            ByteBuf decodedThird = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNotNull((Object)decodedThird);
            TestThriftFramedDecoder.assertContentEquals(decodedThird, third);
            decodedThird.release();
            buffer.release();
        }
    }

    @Test
    public void testChunked() {
        byte[] first = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] second = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] third = new byte[]{5, 4, 3};
        try (TestingPooledByteBufAllocator allocator = new TestingPooledByteBufAllocator();){
            ByteBuf buffer = allocator.buffer(1024);
            ThriftFramedDecoder decoder = TestThriftFramedDecoder.createDecoder(second.length);
            ByteBuf decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNull((Object)decoded);
            buffer.writeByte(171);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNull((Object)decoded);
            Assert.assertEquals((int)buffer.readerIndex(), (int)0);
            Assert.assertEquals((int)buffer.writerIndex(), (int)1);
            buffer.writerIndex(0);
            buffer.writeInt(first.length);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNull((Object)decoded);
            Assert.assertEquals((int)buffer.readerIndex(), (int)0);
            Assert.assertEquals((int)buffer.writerIndex(), (int)4);
            buffer.writeBytes(first, 0, 5);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNull((Object)decoded);
            Assert.assertEquals((int)buffer.readerIndex(), (int)0);
            Assert.assertEquals((int)buffer.writerIndex(), (int)9);
            buffer.writeBytes(first, 5, first.length - 5);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNotNull((Object)decoded);
            TestThriftFramedDecoder.assertContentEquals(decoded, first);
            decoded.release();
            TestThriftFramedDecoder.writeLengthPrefixedFrame(buffer, second);
            buffer.writeInt(third.length);
            buffer.writeBytes(third, 0, 1);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNotNull((Object)decoded);
            TestThriftFramedDecoder.assertContentEquals(decoded, second);
            decoded.release();
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNull((Object)decoded);
            buffer.writeBytes(third, 1, third.length - 1);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNotNull((Object)decoded);
            TestThriftFramedDecoder.assertContentEquals(decoded, third);
            decoded.release();
            Assert.assertEquals((int)buffer.readerIndex(), (int)buffer.writerIndex());
            buffer.release();
        }
    }

    @Test
    public void testBeyondLimit() throws Exception {
        try (TestingPooledByteBufAllocator allocator = new TestingPooledByteBufAllocator();){
            byte[] small = new byte[]{5, 4, 3};
            byte[] firstLargeFrame = TestThriftFramedDecoder.createTestFrame((ByteBufAllocator)allocator, "first_method", 1, (byte)1);
            byte[] secondLargeFrame = TestThriftFramedDecoder.createTestFrame((ByteBufAllocator)allocator, "second_method", 2, (byte)4);
            byte[] invalidLargeFrame = TestThriftFramedDecoder.createInvalidFrame();
            FrameInfo firstFrameInfo = new FrameInfo("first_method", 1, 1, Transport.FRAMED, Protocol.BINARY, true);
            FrameInfo secondFrameInfo = new FrameInfo("second_method", 4, 2, Transport.FRAMED, Protocol.BINARY, true);
            ByteBuf buffer = allocator.buffer(1024);
            ThriftFramedDecoder decoder = TestThriftFramedDecoder.createDecoder(firstLargeFrame.length - 5);
            TestThriftFramedDecoder.writeLengthPrefixedFrame(buffer, small);
            ByteBuf decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNotNull((Object)decoded);
            TestThriftFramedDecoder.assertContentEquals(decoded, small);
            decoded.release();
            TestThriftFramedDecoder.writeLengthPrefixedFrame(buffer, firstLargeFrame);
            TestThriftFramedDecoder.writeLengthPrefixedFrame(buffer, small);
            try {
                TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
                Assert.fail((String)"failure expected");
            }
            catch (RuntimeException e) {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(FrameTooLargeException.class)).hasFieldOrPropertyWithValue("frameInfo", Optional.of(firstFrameInfo));
            }
            Assert.assertEquals((int)buffer.readableBytes(), (int)(4 + small.length));
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNotNull((Object)decoded);
            TestThriftFramedDecoder.assertContentEquals(decoded, small);
            decoded.release();
            buffer.writeInt(secondLargeFrame.length);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNull((Object)decoded);
            buffer.writeBytes(secondLargeFrame, 0, 1);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNull((Object)decoded);
            buffer.writeBytes(secondLargeFrame, 1, 2);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNull((Object)decoded);
            buffer.writeBytes(secondLargeFrame, 3, secondLargeFrame.length - 3);
            buffer.writeInt(firstLargeFrame.length);
            buffer.writeBytes(firstLargeFrame, 0, 5);
            try {
                TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
                Assert.fail((String)"failure expected");
            }
            catch (RuntimeException e) {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(FrameTooLargeException.class)).hasFieldOrPropertyWithValue("frameInfo", Optional.of(secondFrameInfo));
            }
            Assert.assertEquals((int)buffer.readableBytes(), (int)9);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNull((Object)decoded);
            buffer.writeBytes(firstLargeFrame, 5, firstLargeFrame.length - 5);
            try {
                TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
                Assert.fail((String)"failure expected");
            }
            catch (RuntimeException e) {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(FrameTooLargeException.class)).hasFieldOrPropertyWithValue("frameInfo", Optional.of(firstFrameInfo));
            }
            Assert.assertEquals((int)buffer.readableBytes(), (int)0);
            TestThriftFramedDecoder.writeLengthPrefixedFrame(buffer, invalidLargeFrame);
            TestThriftFramedDecoder.writeLengthPrefixedFrame(buffer, small);
            try {
                TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
                Assert.fail((String)"failure expected");
            }
            catch (RuntimeException e) {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(FrameTooLargeException.class)).hasFieldOrPropertyWithValue("frameInfo", Optional.empty());
            }
            Assert.assertEquals((int)buffer.readableBytes(), (int)(4 + small.length));
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNotNull((Object)decoded);
            TestThriftFramedDecoder.assertContentEquals(decoded, small);
            decoded.release();
            buffer.writeInt(invalidLargeFrame.length);
            buffer.writeBytes(invalidLargeFrame, 0, invalidLargeFrame.length / 2);
            decoded = TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
            Assert.assertNull((Object)decoded);
            buffer.writeBytes(invalidLargeFrame, invalidLargeFrame.length / 2, invalidLargeFrame.length - invalidLargeFrame.length / 2);
            try {
                TestThriftFramedDecoder.decode((ByteBufAllocator)allocator, decoder, buffer);
                Assert.fail((String)"failure expected");
            }
            catch (RuntimeException e) {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(FrameTooLargeException.class)).hasFieldOrPropertyWithValue("frameInfo", Optional.empty());
            }
            Assert.assertEquals((int)buffer.readableBytes(), (int)0);
            buffer.release();
        }
    }

    private static ThriftFramedDecoder createDecoder(int maxFrameSizeInBytes) {
        return new ThriftFramedDecoder((FrameInfoDecoder)new SimpleFrameInfoDecoder(Transport.FRAMED, Protocol.BINARY, true), maxFrameSizeInBytes);
    }

    private static ByteBuf decode(ByteBufAllocator bufAllocator, ThriftFramedDecoder decoder, ByteBuf input) {
        ArrayList output = new ArrayList(1);
        decoder.decode(TestThriftFramedDecoder.createTestingChannelHandlerContext(bufAllocator), input, output);
        if (output.isEmpty()) {
            return null;
        }
        Assert.assertEquals((int)output.size(), (int)1);
        return (ByteBuf)output.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] createTestFrame(ByteBufAllocator allocator, String methodName, int sequenceId, byte messageType) throws Exception {
        TChannelBufferOutputTransport transport = new TChannelBufferOutputTransport(allocator);
        try {
            TProtocol protocolWriter = Protocol.BINARY.createProtocol((TTransport)transport);
            protocolWriter.writeMessageBegin(new TMessage(methodName, messageType, sequenceId));
            ProtocolWriter writer = new ProtocolWriter((TProtocolWriter)protocolWriter);
            writer.writeStructBegin(methodName + "_args");
            writer.writeStructEnd();
            protocolWriter.writeMessageEnd();
            ByteBuf buffer = transport.getBuffer();
            byte[] result = new byte[buffer.readableBytes()];
            buffer.readBytes(result);
            buffer.release();
            byte[] byArray = result;
            return byArray;
        }
        finally {
            transport.release();
        }
    }

    private static byte[] createInvalidFrame() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(output);
        dataOutput.writeInt(-1430532882);
        dataOutput.writeInt(Integer.MAX_VALUE);
        byte[] data = new byte[1024];
        ThreadLocalRandom.current().nextBytes(data);
        dataOutput.write(data);
        dataOutput.close();
        output.close();
        return output.toByteArray();
    }

    private static void writeLengthPrefixedFrame(ByteBuf buffer, byte[] frame) {
        buffer.writeInt(frame.length);
        buffer.writeBytes(frame);
    }

    private static void assertContentEquals(ByteBuf buffer, byte[] expectedContent) {
        Assert.assertEquals((int)buffer.readableBytes(), (int)expectedContent.length);
        byte[] actual = new byte[buffer.readableBytes()];
        buffer.getBytes(buffer.readerIndex(), actual);
        Assert.assertEquals((byte[])actual, (byte[])expectedContent);
    }

    private static ChannelHandlerContext createTestingChannelHandlerContext(final ByteBufAllocator bufAllocator) {
        return new ChannelHandlerContext(){

            public Channel channel() {
                throw new UnsupportedOperationException();
            }

            public EventExecutor executor() {
                throw new UnsupportedOperationException();
            }

            public String name() {
                throw new UnsupportedOperationException();
            }

            public ChannelHandler handler() {
                throw new UnsupportedOperationException();
            }

            public boolean isRemoved() {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext fireChannelRegistered() {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext fireChannelUnregistered() {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext fireChannelActive() {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext fireChannelInactive() {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext fireUserEventTriggered(Object evt) {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext fireChannelRead(Object msg) {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext fireChannelReadComplete() {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext fireChannelWritabilityChanged() {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext read() {
                throw new UnsupportedOperationException();
            }

            public ChannelHandlerContext flush() {
                throw new UnsupportedOperationException();
            }

            public ChannelPipeline pipeline() {
                throw new UnsupportedOperationException();
            }

            public ByteBufAllocator alloc() {
                return bufAllocator;
            }

            public <T> Attribute<T> attr(AttributeKey<T> key) {
                throw new UnsupportedOperationException();
            }

            public <T> boolean hasAttr(AttributeKey<T> key) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture bind(SocketAddress localAddress) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture connect(SocketAddress remoteAddress) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture disconnect() {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture close() {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture deregister() {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture disconnect(ChannelPromise promise) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture close(ChannelPromise promise) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture deregister(ChannelPromise promise) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture write(Object msg) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture write(Object msg, ChannelPromise promise) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture writeAndFlush(Object msg) {
                throw new UnsupportedOperationException();
            }

            public ChannelPromise newPromise() {
                throw new UnsupportedOperationException();
            }

            public ChannelProgressivePromise newProgressivePromise() {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture newSucceededFuture() {
                throw new UnsupportedOperationException();
            }

            public ChannelFuture newFailedFuture(Throwable cause) {
                throw new UnsupportedOperationException();
            }

            public ChannelPromise voidPromise() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

