/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.drift.transport.netty.buffer.TestingPooledByteBufAllocator;
import com.facebook.drift.transport.netty.codec.ThriftMessageTransformer;
import com.facebook.drift.transport.netty.codec.ZlibTransformer;
import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftMessageTransformer {
    @Test
    public void testZlibRoundTrips() throws IOException {
        TestThriftMessageTransformer.assertRoundTrip((ThriftMessageTransformer)new ZlibTransformer(512), "123");
        TestThriftMessageTransformer.assertRoundTrip((ThriftMessageTransformer)new ZlibTransformer(1), Strings.repeat((String)"a", (int)100000));
        TestThriftMessageTransformer.assertRoundTrip((ThriftMessageTransformer)new ZlibTransformer(512), Strings.repeat((String)"a", (int)100000));
        TestThriftMessageTransformer.assertRoundTrip((ThriftMessageTransformer)new ZlibTransformer(1), TestThriftMessageTransformer.randomString(100000));
        TestThriftMessageTransformer.assertRoundTrip((ThriftMessageTransformer)new ZlibTransformer(512), TestThriftMessageTransformer.randomString(100000));
        TestThriftMessageTransformer.assertRoundTrip((ThriftMessageTransformer)new ZlibTransformer(200000), TestThriftMessageTransformer.randomString(100000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZlibAttemptPartialRead() throws IOException {
        try (TestingPooledByteBufAllocator allocator = new TestingPooledByteBufAllocator();){
            ByteBuf transformed = null;
            ByteBuf untransformed = null;
            try {
                transformed = TestThriftMessageTransformer.encode((ByteBufAllocator)allocator, (ThriftMessageTransformer)new ZlibTransformer(2), Strings.repeat((String)"a", (int)1000));
                try {
                    untransformed = TestThriftMessageTransformer.decode((ByteBufAllocator)allocator, (ThriftMessageTransformer)new ZlibTransformer(2), transformed.retainedSlice(0, 10));
                    throw new Exception("not expected");
                }
                catch (Throwable t) {
                    Assert.assertFalse((boolean)t.getMessage().equals("not expected"));
                    untransformed = TestThriftMessageTransformer.tryDecode((ByteBufAllocator)allocator, (ThriftMessageTransformer)new ZlibTransformer(2), transformed.retainedSlice(0, 10), 5);
                    Assert.assertTrue((boolean)TestThriftMessageTransformer.toString(untransformed).startsWith("a"));
                    untransformed.release();
                    untransformed = TestThriftMessageTransformer.tryDecode((ByteBufAllocator)allocator, (ThriftMessageTransformer)new ZlibTransformer(2), transformed.retainedSlice(0, 17), 1);
                    Assert.assertTrue((boolean)TestThriftMessageTransformer.toString(untransformed).startsWith("a"));
                    untransformed.release();
                    untransformed = TestThriftMessageTransformer.tryDecode((ByteBufAllocator)allocator, (ThriftMessageTransformer)new ZlibTransformer(2), transformed.retainedSlice(0, 1), 10);
                    Assert.assertFalse((boolean)TestThriftMessageTransformer.toString(untransformed).startsWith("a"));
                    if (transformed != null) {
                        transformed.release();
                    }
                    if (untransformed != null) {
                        untransformed.release();
                    }
                }
            }
            catch (Throwable throwable) {
                if (transformed != null) {
                    transformed.release();
                }
                if (untransformed != null) {
                    untransformed.release();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertRoundTrip(ThriftMessageTransformer transformer, String input) throws IOException {
        try (TestingPooledByteBufAllocator allocator = new TestingPooledByteBufAllocator();){
            ByteBuf inputBuffer = allocator.buffer();
            inputBuffer.writeBytes(input.getBytes());
            ByteBuf outputBuffer = null;
            try {
                ByteBuf transformed = transformer.transform((ByteBufAllocator)allocator, inputBuffer.retain());
                outputBuffer = transformer.untransform((ByteBufAllocator)allocator, transformed);
                Assert.assertEquals((String)input, (String)TestThriftMessageTransformer.toString(outputBuffer));
            }
            finally {
                inputBuffer.release();
                if (outputBuffer != null) {
                    outputBuffer.release();
                }
            }
        }
    }

    private static String randomString(int size) {
        byte[] array = new byte[size];
        new Random().nextBytes(array);
        return new String(array, Charset.forName("UTF-8"));
    }

    private static String toString(ByteBuf byteBuf) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteBuf input = byteBuf.retainedDuplicate();
        try {
            input.readBytes((OutputStream)outputStream, byteBuf.readableBytes());
        }
        finally {
            input.release();
        }
        return ((Object)outputStream).toString();
    }

    private static ByteBuf encode(ByteBufAllocator allocator, ThriftMessageTransformer transformer, String input) {
        ByteBuf inputBuffer = allocator.buffer();
        inputBuffer.writeBytes(input.getBytes());
        return transformer.transform(allocator, inputBuffer);
    }

    private static ByteBuf decode(ByteBufAllocator allocator, ThriftMessageTransformer transformer, ByteBuf input) {
        return transformer.untransform(allocator, input);
    }

    private static ByteBuf tryDecode(ByteBufAllocator allocator, ThriftMessageTransformer transformer, ByteBuf input, int sizeLimit) {
        return transformer.tryUntransform(allocator, input, sizeLimit);
    }
}

