/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.server;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.drift.transport.netty.server.DriftNettyServerConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestDriftNettyServerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((DriftNettyServerConfig)ConfigAssertions.recordDefaults(DriftNettyServerConfig.class)).setPort(0).setAcceptBacklog(1024).setIoThreadCount(3).setWorkerThreadCount(Runtime.getRuntime().availableProcessors() * 2).setRequestTimeout(new Duration(1.0, TimeUnit.MINUTES)).setMaxFrameSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setSslContextRefreshTime(new Duration(1.0, TimeUnit.MINUTES)).setAllowPlaintext(true).setSslEnabled(false).setTrustCertificate(null).setKey(null).setKeyPassword(null).setSessionCacheSize(10000L).setSessionTimeout(new Duration(1.0, TimeUnit.DAYS)).setCiphers("").setAssumeClientsSupportOutOfOrderResponses(true).setNativeTransportEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"thrift.server.port", (Object)"99").put((Object)"thrift.server.accept-backlog", (Object)"101").put((Object)"thrift.server.io-thread-count", (Object)"202").put((Object)"thrift.server.worker-thread-count", (Object)"303").put((Object)"thrift.server.request-timeout", (Object)"33m").put((Object)"thrift.server.max-frame-size", (Object)"55MB").put((Object)"thrift.server.ssl-context.refresh-time", (Object)"33m").put((Object)"thrift.server.allow-plaintext", (Object)"false").put((Object)"thrift.server.ssl.enabled", (Object)"true").put((Object)"thrift.server.ssl.trust-certificate", (Object)"trust").put((Object)"thrift.server.ssl.key", (Object)"key").put((Object)"thrift.server.ssl.key-password", (Object)"key_password").put((Object)"thrift.server.ssl.session-cache-size", (Object)"678").put((Object)"thrift.server.ssl.session-timeout", (Object)"78h").put((Object)"thrift.server.ssl.ciphers", (Object)"some_cipher").put((Object)"thrift.server.assume-clients-support-out-of-order-responses", (Object)"false").put((Object)"thrift.server.native-transport.enabled", (Object)"true").build();
        DriftNettyServerConfig expected = new DriftNettyServerConfig().setPort(99).setAcceptBacklog(101).setIoThreadCount(202).setWorkerThreadCount(303).setRequestTimeout(new Duration(33.0, TimeUnit.MINUTES)).setMaxFrameSize(new DataSize(55.0, DataSize.Unit.MEGABYTE)).setSslContextRefreshTime(new Duration(33.0, TimeUnit.MINUTES)).setAllowPlaintext(false).setSslEnabled(true).setTrustCertificate(new File("trust")).setKey(new File("key")).setKeyPassword("key_password").setSessionCacheSize(678L).setSessionTimeout(new Duration(78.0, TimeUnit.HOURS)).setCiphers("some_cipher").setAssumeClientsSupportOutOfOrderResponses(false).setNativeTransportEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

