/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.server;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.transport.MethodMetadata;
import com.facebook.drift.transport.ParameterMetadata;
import com.facebook.drift.transport.netty.buffer.TestingPooledByteBufAllocator;
import com.facebook.drift.transport.netty.scribe.apache.LogEntry;
import com.facebook.drift.transport.netty.scribe.apache.ResultCode;
import com.facebook.drift.transport.netty.scribe.apache.scribe;
import com.facebook.drift.transport.netty.scribe.drift.DriftLogEntry;
import com.facebook.drift.transport.netty.scribe.drift.DriftResultCode;
import com.facebook.drift.transport.netty.server.DriftNettyServerConfig;
import com.facebook.drift.transport.netty.server.DriftNettyServerTransport;
import com.facebook.drift.transport.netty.server.DriftNettyServerTransportFactory;
import com.facebook.drift.transport.server.ServerInvokeRequest;
import com.facebook.drift.transport.server.ServerMethodInvoker;
import com.facebook.drift.transport.server.ServerTransport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDriftNettyServerTransport {
    private static final ThriftCodecManager CODEC_MANAGER = new ThriftCodecManager(new ThriftCodec[0]);
    private static final MethodMetadata LOG_METHOD_METADATA = new MethodMetadata("Log", (List)ImmutableList.of((Object)new ParameterMetadata(1, "messages", CODEC_MANAGER.getCodec(ThriftType.list((ThriftType)CODEC_MANAGER.getCodec(DriftLogEntry.class).getType())))), CODEC_MANAGER.getCodec(DriftResultCode.class), (Map)ImmutableMap.of(), false, true);
    private static final List<LogEntry> MESSAGES = ImmutableList.of((Object)new LogEntry("hello", "world"), (Object)new LogEntry("bye", "world"));
    private static final List<DriftLogEntry> DRIFT_MESSAGES = ImmutableList.copyOf((Collection)MESSAGES.stream().map(input -> new DriftLogEntry(input.category, input.message)).collect(Collectors.toList()));

    @Test
    public void testOutOfOrderNot() {
        TestingServerMethodInvoker methodInvoker = new TestingServerMethodInvoker();
        int invocationCount = TestDriftNettyServerTransport.testServerMethodInvoker(methodInvoker, true, (List<ToIntFunction<HostAndPort>>)ImmutableList.of(address -> TestDriftNettyServerTransport.testOutOfOrder(address, MESSAGES, new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), methodInvoker.getFutureResults()), address -> TestDriftNettyServerTransport.testOutOfOrder(address, MESSAGES, new TTransportFactory(), (TProtocolFactory)new TCompactProtocol.Factory(), methodInvoker.getFutureResults()), address -> TestDriftNettyServerTransport.testOutOfOrder(address, MESSAGES, (TTransportFactory)new TFramedTransport.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), methodInvoker.getFutureResults()), address -> TestDriftNettyServerTransport.testOutOfOrder(address, MESSAGES, (TTransportFactory)new TFramedTransport.Factory(), (TProtocolFactory)new TCompactProtocol.Factory(), methodInvoker.getFutureResults())));
        ArrayList expectedMessages = Lists.newArrayList((Iterable)Iterables.concat(Collections.nCopies(invocationCount, DRIFT_MESSAGES)));
        Assert.assertEquals((Collection)ImmutableList.copyOf((Collection)methodInvoker.getMessages()), (Collection)expectedMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int testOutOfOrder(HostAndPort address, List<LogEntry> messages, TTransportFactory framingFactory, TProtocolFactory protocolFactory, BlockingQueue<SettableFuture<Object>> results) {
        try {
            socket.open();
            try (TSocket socket = new TSocket(address.getHost(), address.getPort());){
                TProtocol protocol = protocolFactory.getProtocol(framingFactory.getTransport((TTransport)socket));
                TestDriftNettyServerTransport.sendLogRequest(11, messages, protocol);
                SettableFuture<Object> firstResult = results.take();
                Assert.assertFalse((boolean)firstResult.isDone());
                TestDriftNettyServerTransport.sendLogRequest(22, messages, protocol);
                SettableFuture<Object> secondResult = results.take();
                Assert.assertFalse((boolean)secondResult.isDone());
                secondResult.set((Object)DriftResultCode.OK);
                Assert.assertEquals((Object)((Object)TestDriftNettyServerTransport.readLogResponse(22, protocol)), (Object)((Object)ResultCode.OK));
                Assert.assertFalse((boolean)firstResult.isDone());
                firstResult.set((Object)DriftResultCode.OK);
                Assert.assertEquals((Object)((Object)TestDriftNettyServerTransport.readLogResponse(11, protocol)), (Object)((Object)ResultCode.OK));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return 2;
    }

    @Test
    public void testOutOfOrderNotSupported() {
        TestingServerMethodInvoker methodInvoker = new TestingServerMethodInvoker();
        int invocationCount = TestDriftNettyServerTransport.testServerMethodInvoker(methodInvoker, false, (List<ToIntFunction<HostAndPort>>)ImmutableList.of(address -> TestDriftNettyServerTransport.testOutOfOrderNotSupported(address, MESSAGES, new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), methodInvoker.getFutureResults()), address -> TestDriftNettyServerTransport.testOutOfOrderNotSupported(address, MESSAGES, new TTransportFactory(), (TProtocolFactory)new TCompactProtocol.Factory(), methodInvoker.getFutureResults()), address -> TestDriftNettyServerTransport.testOutOfOrderNotSupported(address, MESSAGES, (TTransportFactory)new TFramedTransport.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), methodInvoker.getFutureResults()), address -> TestDriftNettyServerTransport.testOutOfOrderNotSupported(address, MESSAGES, (TTransportFactory)new TFramedTransport.Factory(), (TProtocolFactory)new TCompactProtocol.Factory(), methodInvoker.getFutureResults())));
        ArrayList expectedMessages = Lists.newArrayList((Iterable)Iterables.concat(Collections.nCopies(invocationCount, DRIFT_MESSAGES)));
        Assert.assertEquals((Collection)ImmutableList.copyOf((Collection)methodInvoker.getMessages()), (Collection)expectedMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int testOutOfOrderNotSupported(HostAndPort address, List<LogEntry> messages, TTransportFactory framingFactory, TProtocolFactory protocolFactory, BlockingQueue<SettableFuture<Object>> results) {
        try {
            socket.open();
            try (TSocket socket = new TSocket(address.getHost(), address.getPort());){
                TProtocol protocol = protocolFactory.getProtocol(framingFactory.getTransport((TTransport)socket));
                TestDriftNettyServerTransport.sendLogRequest(11, messages, protocol);
                SettableFuture<Object> firstResult = results.take();
                Assert.assertFalse((boolean)firstResult.isDone());
                TestDriftNettyServerTransport.sendLogRequest(22, messages, protocol);
                Assert.assertNull(results.poll(1L, TimeUnit.SECONDS), (String)"Second request future");
                Assert.assertFalse((boolean)firstResult.isDone());
                firstResult.set((Object)DriftResultCode.OK);
                Assert.assertEquals((Object)((Object)TestDriftNettyServerTransport.readLogResponse(11, protocol)), (Object)((Object)ResultCode.OK));
                SettableFuture<Object> secondResult = results.take();
                Assert.assertFalse((boolean)secondResult.isDone());
                secondResult.set((Object)DriftResultCode.OK);
                Assert.assertEquals((Object)((Object)TestDriftNettyServerTransport.readLogResponse(22, protocol)), (Object)((Object)ResultCode.OK));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int testServerMethodInvoker(ServerMethodInvoker methodInvoker, boolean assumeClientsSupportOutOfOrderResponses, List<ToIntFunction<HostAndPort>> clients) {
        DriftNettyServerConfig config = new DriftNettyServerConfig().setAssumeClientsSupportOutOfOrderResponses(assumeClientsSupportOutOfOrderResponses);
        TestingPooledByteBufAllocator testingAllocator = new TestingPooledByteBufAllocator();
        ServerTransport serverTransport = new DriftNettyServerTransportFactory(config, (ByteBufAllocator)testingAllocator).createServerTransport(methodInvoker);
        try {
            serverTransport.start();
            HostAndPort address = HostAndPort.fromParts((String)"localhost", (int)((DriftNettyServerTransport)serverTransport).getPort());
            int sum = 0;
            for (ToIntFunction<HostAndPort> client : clients) {
                sum += client.applyAsInt(address);
            }
            int n = sum;
            return n;
        }
        finally {
            serverTransport.shutdown();
            testingAllocator.close();
        }
    }

    private static void sendLogRequest(int sequenceId, List<LogEntry> messages, TProtocol protocol) throws TException {
        protocol.writeMessageBegin(new TMessage("Log", 1, sequenceId));
        new scribe.Log_args().setMessages(messages).write(protocol);
        protocol.writeMessageEnd();
        protocol.getTransport().flush();
    }

    private static ResultCode readLogResponse(int expectedSequenceId, TProtocol protocol) throws TException {
        TMessage message = protocol.readMessageBegin();
        if (message.type == 3) {
            throw TApplicationException.readFrom((TProtocol)protocol);
        }
        if (message.type != 2) {
            throw new TApplicationException(5, "request failed");
        }
        if (message.seqid != expectedSequenceId) {
            throw new TApplicationException(4, String.format("expected sequenceId %s, but received %s", expectedSequenceId, message.seqid));
        }
        scribe.Log_result result = new scribe.Log_result();
        result.read(protocol);
        protocol.readMessageEnd();
        return result.success;
    }

    private static class TestingServerMethodInvoker
    implements ServerMethodInvoker {
        private final BlockingQueue<SettableFuture<Object>> futureResults = new ArrayBlockingQueue<SettableFuture<Object>>(100);
        private final List<LogEntry> messages = new CopyOnWriteArrayList<LogEntry>();

        private TestingServerMethodInvoker() {
        }

        public BlockingQueue<SettableFuture<Object>> getFutureResults() {
            return this.futureResults;
        }

        private List<LogEntry> getMessages() {
            return this.messages;
        }

        public Optional<MethodMetadata> getMethodMetadata(String name) {
            if (LOG_METHOD_METADATA.getName().equals(name)) {
                return Optional.of(LOG_METHOD_METADATA);
            }
            return Optional.empty();
        }

        public ListenableFuture<Object> invoke(ServerInvokeRequest request) {
            MethodMetadata method = request.getMethod();
            if (!LOG_METHOD_METADATA.getName().equals(method.getName())) {
                return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("unknown method " + method));
            }
            Map parameters = request.getParameters();
            if (parameters.size() != 1 || !parameters.containsKey((short)1) || !(Iterables.getOnlyElement(parameters.values()) instanceof List)) {
                return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("invalid parameters"));
            }
            this.messages.addAll((List)Iterables.getOnlyElement(parameters.values()));
            SettableFuture result = SettableFuture.create();
            this.futureResults.add((SettableFuture<Object>)result);
            return result;
        }

        public void recordResult(String methodName, long startTime, ListenableFuture<Object> result) {
        }
    }
}

