/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.configuration.Config;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.Transport;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class DriftNettyClientConfig {
    private Transport transport = Transport.HEADER;
    private Protocol protocol = Protocol.BINARY;
    private DataSize maxFrameSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private Duration connectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private Duration requestTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private HostAndPort socksProxy;
    private boolean sslEnabled;
    private List<String> ciphers = ImmutableList.of();
    private File trustCertificate;
    private File key;
    private String keyPassword;
    private long sessionCacheSize = 10000L;
    private Duration sessionTimeout = new Duration(1.0, TimeUnit.DAYS);
    private Boolean connectionPoolEnabled;
    private Integer connectionPoolMaxSize;
    private Integer connectionPoolMaxConnectionsPerDestination;
    private Duration connectionPoolIdleTimeout;
    private boolean tcpNoDelayEnabled;
    private boolean reuseAddressEnabled;

    @NotNull
    public Transport getTransport() {
        return this.transport;
    }

    @Config(value="thrift.client.transport")
    public DriftNettyClientConfig setTransport(Transport transport) {
        this.transport = transport;
        return this;
    }

    @NotNull
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Config(value="thrift.client.protocol")
    public DriftNettyClientConfig setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="thrift.client.connect-timeout")
    public DriftNettyClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="thrift.client.request-timeout")
    public DriftNettyClientConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="thrift.client.socks-proxy")
    public DriftNettyClientConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    @MaxDataSize(value="1023MB")
    public DataSize getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Config(value="thrift.client.max-frame-size")
    public DriftNettyClientConfig setMaxFrameSize(DataSize maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    @Config(value="thrift.client.ssl.enabled")
    public DriftNettyClientConfig setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    public File getTrustCertificate() {
        return this.trustCertificate;
    }

    @Config(value="thrift.client.ssl.trust-certificate")
    public DriftNettyClientConfig setTrustCertificate(File trustCertificate) {
        this.trustCertificate = trustCertificate;
        return this;
    }

    public File getKey() {
        return this.key;
    }

    @Config(value="thrift.client.ssl.key")
    public DriftNettyClientConfig setKey(File key) {
        this.key = key;
        return this;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Config(value="thrift.client.ssl.key-password")
    public DriftNettyClientConfig setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public long getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Config(value="thrift.client.ssl.session-cache-size")
    public DriftNettyClientConfig setSessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
        return this;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Config(value="thrift.client.ssl.session-timeout")
    public DriftNettyClientConfig setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public List<String> getCiphers() {
        return this.ciphers;
    }

    @Config(value="thrift.client.ssl.ciphers")
    public DriftNettyClientConfig setCiphers(String ciphers) {
        this.ciphers = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(ciphers, "ciphers is null"));
        return this;
    }

    public Boolean getConnectionPoolEnabled() {
        return this.connectionPoolEnabled;
    }

    @Config(value="thrift.client.connection-pool.enabled")
    public DriftNettyClientConfig setConnectionPoolEnabled(Boolean connectionPoolEnabled) {
        this.connectionPoolEnabled = connectionPoolEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getConnectionPoolMaxConnectionsPerDestination() {
        return this.connectionPoolMaxConnectionsPerDestination;
    }

    @Config(value="thrift.client.connection-pool.max-connections-per-destination")
    public DriftNettyClientConfig setConnectionPoolMaxConnectionsPerDestination(Integer maxConnectionsPerDestination) {
        this.connectionPoolMaxConnectionsPerDestination = maxConnectionsPerDestination;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getConnectionPoolMaxSize() {
        return this.connectionPoolMaxSize;
    }

    @Config(value="thrift.client.connection-pool.max-size")
    public DriftNettyClientConfig setConnectionPoolMaxSize(Integer connectionPoolMaxSize) {
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getConnectionPoolIdleTimeout() {
        return this.connectionPoolIdleTimeout;
    }

    @Config(value="thrift.client.connection-pool.idle-timeout")
    public DriftNettyClientConfig setConnectionPoolIdleTimeout(Duration connectionPoolIdleTimeout) {
        this.connectionPoolIdleTimeout = connectionPoolIdleTimeout;
        return this;
    }

    public boolean isTcpNoDelayEnabled() {
        return this.tcpNoDelayEnabled;
    }

    @Config(value="thrift.client.tcp-no-delay.enabled")
    public DriftNettyClientConfig setTcpNoDelayEnabled(boolean tcpNoDelayEnabled) {
        this.tcpNoDelayEnabled = tcpNoDelayEnabled;
        return this;
    }

    public boolean isReuseAddressEnabled() {
        return this.reuseAddressEnabled;
    }

    @Config(value="thrift.client.reuse-address.enabled")
    public DriftNettyClientConfig setReuseAddressEnabled(boolean reuseAddressEnabled) {
        this.reuseAddressEnabled = reuseAddressEnabled;
        return this;
    }
}

