/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.drift.transport.netty.codec.ThriftMessageTransformer;
import com.facebook.drift.transport.netty.codec.ZlibTransformer;
import java.util.Objects;

public enum ThriftHeaderTransform {
    ZLIB_TRANSFORM(1, ZlibTransformer.ZLIB_TRANSFORMER);

    private final int id;
    private final ThriftMessageTransformer messageTransformer;

    private ThriftHeaderTransform(int id, ThriftMessageTransformer messageTransformer) {
        this.id = id;
        this.messageTransformer = Objects.requireNonNull(messageTransformer, "messageTransformer is null.");
    }

    public int getId() {
        return this.id;
    }

    public static ThriftHeaderTransform fromId(int transformId) {
        for (ThriftHeaderTransform transform : ThriftHeaderTransform.values()) {
            if (transform.id != transformId) continue;
            return transform;
        }
        throw new UnsupportedOperationException(String.format("Unknown transform %s during receive", transformId));
    }

    public ThriftMessageTransformer getMessageTransformer() {
        return this.messageTransformer;
    }
}

