/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

public class DriftNettyConnectionFactoryConfig {
    private static final int DEFAULT_THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private int threadCount = DEFAULT_THREAD_COUNT;
    private boolean connectionPoolEnabled = true;
    private int connectionPoolMaxSize = 1000;
    private int connectionPoolMaxConnectionsPerDestination = 1;
    private Duration connectionPoolIdleTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private Duration sslContextRefreshTime = new Duration(1.0, TimeUnit.MINUTES);
    private HostAndPort socksProxy;
    private boolean nativeTransportEnabled;

    public int getThreadCount() {
        return this.threadCount;
    }

    @Config(value="thrift.client.thread-count")
    public DriftNettyConnectionFactoryConfig setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public boolean isConnectionPoolEnabled() {
        return this.connectionPoolEnabled;
    }

    @Config(value="thrift.client.connection-pool.enabled")
    public DriftNettyConnectionFactoryConfig setConnectionPoolEnabled(boolean connectionPoolEnabled) {
        this.connectionPoolEnabled = connectionPoolEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConnectionPoolMaxConnectionsPerDestination() {
        return this.connectionPoolMaxConnectionsPerDestination;
    }

    @Config(value="thrift.client.connection-pool.max-connections-per-destination")
    public DriftNettyConnectionFactoryConfig setConnectionPoolMaxConnectionsPerDestination(int maxConnectionsPerDestination) {
        this.connectionPoolMaxConnectionsPerDestination = maxConnectionsPerDestination;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConnectionPoolMaxSize() {
        return this.connectionPoolMaxSize;
    }

    @Config(value="thrift.client.connection-pool.max-size")
    public DriftNettyConnectionFactoryConfig setConnectionPoolMaxSize(int connectionPoolMaxSize) {
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getConnectionPoolIdleTimeout() {
        return this.connectionPoolIdleTimeout;
    }

    @Config(value="thrift.client.connection-pool.idle-timeout")
    public DriftNettyConnectionFactoryConfig setConnectionPoolIdleTimeout(Duration connectionPoolIdleTimeout) {
        this.connectionPoolIdleTimeout = connectionPoolIdleTimeout;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getSslContextRefreshTime() {
        return this.sslContextRefreshTime;
    }

    @Config(value="thrift.client.ssl-context.refresh-time")
    public DriftNettyConnectionFactoryConfig setSslContextRefreshTime(Duration sslContextRefreshTime) {
        this.sslContextRefreshTime = sslContextRefreshTime;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="thrift.client.socks-proxy")
    public DriftNettyConnectionFactoryConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    public boolean isNativeTransportEnabled() {
        return this.nativeTransportEnabled;
    }

    @Config(value="thrift.client.native-transport.enabled")
    @ConfigDescription(value="Enable Native Transport")
    public DriftNettyConnectionFactoryConfig setNativeTransportEnabled(boolean nativeTransportEnabled) {
        this.nativeTransportEnabled = nativeTransportEnabled;
        return this;
    }
}

