/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.drift.transport.netty.codec.ThriftMessageTransformer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class ZlibTransformer
implements ThriftMessageTransformer {
    public static final ZlibTransformer ZLIB_TRANSFORMER = new ZlibTransformer(512);
    private final int zipBlockSize;

    public ZlibTransformer(int zipBlockSize) {
        this.zipBlockSize = zipBlockSize;
    }

    @Override
    public ByteBuf transform(ByteBufAllocator bufAllocator, ByteBuf input) {
        ByteBuf output = bufAllocator.buffer(this.zipBlockSize);
        try (DeflaterOutputStream outputStream = new DeflaterOutputStream((OutputStream)new ByteBufOutputStream(output));){
            input.readBytes((OutputStream)outputStream, input.readableBytes());
        }
        catch (IOException e) {
            output.release();
            throw new UncheckedIOException(e);
        }
        finally {
            input.release();
        }
        return output;
    }

    @Override
    public ByteBuf untransform(ByteBufAllocator bufAllocator, ByteBuf input) {
        ByteBuf output = bufAllocator.buffer(this.zipBlockSize);
        try {
            ByteBuf byteBuf;
            InflaterInputStream inputStream = new InflaterInputStream((InputStream)new ByteBufInputStream(input));
            try {
                while (inputStream.available() > 0) {
                    output.writeBytes((InputStream)inputStream, this.zipBlockSize);
                }
                byteBuf = output;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    output.release();
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
            return byteBuf;
        }
        finally {
            input.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf tryUntransform(ByteBufAllocator bufAllocator, ByteBuf input, int byteLimit) {
        ByteBuf output = bufAllocator.buffer(this.zipBlockSize);
        try {
            ByteBuf byteBuf;
            InflaterInputStream inputStream = new InflaterInputStream((InputStream)new ByteBufInputStream(input));
            try {
                while (inputStream.available() > 0) {
                    output.writeBytes((InputStream)inputStream, this.zipBlockSize);
                    if (byteLimit <= 0 || output.readableBytes() < byteLimit) continue;
                }
                byteBuf = output;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ByteBuf byteBuf2 = output;
                    return byteBuf2;
                }
            }
            inputStream.close();
            return byteBuf;
        }
        finally {
            input.release();
        }
    }
}

