/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.server;

import com.facebook.drift.transport.netty.server.DriftNettyServerConfig;
import com.facebook.drift.transport.netty.server.DriftNettyServerTransport;
import com.facebook.drift.transport.server.ServerMethodInvoker;
import com.facebook.drift.transport.server.ServerTransport;
import com.facebook.drift.transport.server.ServerTransportFactory;
import io.netty.buffer.ByteBufAllocator;
import java.util.Objects;
import javax.inject.Inject;

public class DriftNettyServerTransportFactory
implements ServerTransportFactory {
    private final DriftNettyServerConfig config;
    private final ByteBufAllocator allocator;

    public DriftNettyServerTransportFactory(DriftNettyServerConfig config) {
        this(config, ByteBufAllocator.DEFAULT);
    }

    @Inject
    public DriftNettyServerTransportFactory(DriftNettyServerConfig config, ByteBufAllocator allocator) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.allocator = Objects.requireNonNull(allocator, "allocator is null");
    }

    public ServerTransport createServerTransport(ServerMethodInvoker methodInvoker) {
        return new DriftNettyServerTransport(methodInvoker, this.config, this.allocator);
    }
}

