/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.drift.transport.client.DriftClientConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestDriftClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((DriftClientConfig)ConfigAssertions.recordDefaults(DriftClientConfig.class)).setMaxRetries(5).setMinBackoffDelay(new Duration(100.0, TimeUnit.MILLISECONDS)).setMaxBackoffDelay(new Duration(30.0, TimeUnit.SECONDS)).setBackoffScaleFactor(2.0).setMaxRetryTime(new Duration(1.0, TimeUnit.MINUTES)).setStatsEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"thrift.client.max-retries", (Object)"99").put((Object)"thrift.client.min-backoff-delay", (Object)"11ms").put((Object)"thrift.client.max-backoff-delay", (Object)"22m").put((Object)"thrift.client.backoff-scale-factor", (Object)"2.2").put((Object)"thrift.client.max-retry-time", (Object)"33m").put((Object)"thrift.client.stats.enabled", (Object)"false").build();
        DriftClientConfig expected = new DriftClientConfig().setMaxRetries(99).setMinBackoffDelay(new Duration(11.0, TimeUnit.MILLISECONDS)).setMaxBackoffDelay(new Duration(22.0, TimeUnit.MINUTES)).setBackoffScaleFactor(2.2).setMaxRetryTime(new Duration(33.0, TimeUnit.MINUTES)).setStatsEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

