/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fbui.textlayoutbuilder.proxy;

import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import androidx.core.text.TextDirectionHeuristicCompat;
import androidx.core.text.TextDirectionHeuristicsCompat;

public class StaticLayoutProxy {
    public static StaticLayout create(CharSequence text, int start, int end, TextPaint paint, int width, Layout.Alignment alignment, float spacingMult, float spacingAdd, boolean includePadding, TextUtils.TruncateAt ellipsize, int ellipsisWidth, int maxLines, TextDirectionHeuristicCompat textDirection) {
        try {
            return new StaticLayout(text, start, end, paint, width, alignment, StaticLayoutProxy.fromTextDirectionHeuristicCompat(textDirection), spacingMult, spacingAdd, includePadding, ellipsize, ellipsisWidth, maxLines);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("utext_close")) {
                return new StaticLayout(text, start, end, paint, width, alignment, StaticLayoutProxy.fromTextDirectionHeuristicCompat(textDirection), spacingMult, spacingAdd, includePadding, ellipsize, ellipsisWidth, maxLines);
            }
            throw e;
        }
    }

    public static TextDirectionHeuristic fromTextDirectionHeuristicCompat(TextDirectionHeuristicCompat textDirection) {
        if (textDirection == TextDirectionHeuristicsCompat.LTR) {
            return TextDirectionHeuristics.LTR;
        }
        if (textDirection == TextDirectionHeuristicsCompat.RTL) {
            return TextDirectionHeuristics.RTL;
        }
        if (textDirection == TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR) {
            return TextDirectionHeuristics.FIRSTSTRONG_LTR;
        }
        if (textDirection == TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL) {
            return TextDirectionHeuristics.FIRSTSTRONG_RTL;
        }
        if (textDirection == TextDirectionHeuristicsCompat.ANYRTL_LTR) {
            return TextDirectionHeuristics.ANYRTL_LTR;
        }
        if (textDirection == TextDirectionHeuristicsCompat.LOCALE) {
            return TextDirectionHeuristics.LOCALE;
        }
        return TextDirectionHeuristics.FIRSTSTRONG_LTR;
    }
}

