/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.flipper.plugins.leakcanary2;

import com.facebook.flipper.core.FlipperConnection;
import com.facebook.flipper.core.FlipperObject;
import com.facebook.flipper.core.FlipperPlugin;
import com.facebook.flipper.core.FlipperResponder;
import com.facebook.flipper.plugins.leakcanary2.Leak;
import com.facebook.flipper.plugins.leakcanary2.LeakCanary2Report;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u001b\u0010\u000f\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/flipper/plugins/leakcanary2/LeakCanary2FlipperPlugin;", "Lcom/facebook/flipper/core/FlipperPlugin;", "()V", "alreadySeenLeakSignatures", "", "", "connection", "Lcom/facebook/flipper/core/FlipperConnection;", "leaks", "", "Lcom/facebook/flipper/plugins/leakcanary2/Leak;", "getId", "onConnect", "", "onDisconnect", "reportLeaks", "", "reportLeaks$leakcanary2_plugin_release", "runInBackground", "", "sendLeakList", "Companion", "leakcanary2-plugin_release"})
public final class LeakCanary2FlipperPlugin
implements FlipperPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Leak> leaks = new ArrayList();
    @NotNull
    private final Set<String> alreadySeenLeakSignatures = new LinkedHashSet();
    @Nullable
    private FlipperConnection connection;
    @NotNull
    public static final String ID = "LeakCanary";

    @NotNull
    public String getId() {
        return ID;
    }

    public void onConnect(@Nullable FlipperConnection connection) {
        this.connection = connection;
        FlipperConnection flipperConnection = connection;
        if (flipperConnection != null) {
            flipperConnection.receive("clear", (arg_0, arg_1) -> LeakCanary2FlipperPlugin.onConnect$lambda-0(this, arg_0, arg_1));
        }
        this.sendLeakList();
    }

    public void onDisconnect() {
        this.connection = null;
    }

    public boolean runInBackground() {
        return false;
    }

    public final void reportLeaks$leakcanary2_plugin_release(@NotNull List<Leak> leaks) {
        Intrinsics.checkNotNullParameter(leaks, (String)"leaks");
        for (Leak leak : leaks) {
            if (this.alreadySeenLeakSignatures.contains(leak.getSignature())) continue;
            this.leaks.add(leak);
            this.alreadySeenLeakSignatures.add(leak.getSignature());
        }
        this.sendLeakList();
    }

    private final void sendLeakList() {
        FlipperConnection flipperConnection = this.connection;
        if (flipperConnection != null) {
            flipperConnection.send("reportLeak2", new LeakCanary2Report(this.leaks).toFlipperObject());
        }
    }

    private static final void onConnect$lambda-0(LeakCanary2FlipperPlugin this$0, FlipperObject $noName_0, FlipperResponder $noName_1) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.leaks.clear();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/flipper/plugins/leakcanary2/LeakCanary2FlipperPlugin$Companion;", "", "()V", "ID", "", "leakcanary2-plugin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

