/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.flipper.plugins.leakcanary2;

import com.facebook.flipper.core.FlipperArray;
import com.facebook.flipper.core.FlipperObject;
import com.facebook.flipper.plugins.leakcanary2.Element;
import com.facebook.flipper.plugins.leakcanary2.Leak;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import shark.LeakTrace;
import shark.LeakTraceObject;
import shark.LeakTraceReference;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000e0\r*\u00020\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00010\u0013H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0018\u0010\b\u001a\u00020\u0004*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"EMPTY_FLIPPER_OBJECT", "Lcom/facebook/flipper/core/FlipperObject;", "kotlin.jvm.PlatformType", "retaining", "", "Lshark/LeakTraceObject;", "getRetaining", "(Lshark/LeakTraceObject;)Ljava/lang/String;", "shortName", "Lshark/LeakTraceObject$LeakingStatus;", "getShortName", "(Lshark/LeakTraceObject$LeakingStatus;)Ljava/lang/String;", "getElements", "", "Lkotlin/Pair;", "Lcom/facebook/flipper/plugins/leakcanary2/Element;", "Lshark/LeakTrace;", "toFlipperArray", "Lcom/facebook/flipper/core/FlipperArray;", "", "toLeak", "Lcom/facebook/flipper/plugins/leakcanary2/Leak;", "title", "leakcanary2-plugin_release"})
public final class LeakCanary2ReportKt {
    private static final FlipperObject EMPTY_FLIPPER_OBJECT = new FlipperObject.Builder().build();

    @NotNull
    public static final Leak toLeak(@NotNull LeakTrace $this$toLeak, @NotNull String title) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toLeak, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        List<Pair<String, Element>> elements = LeakCanary2ReportKt.getElements($this$toLeak);
        Map map = MapsKt.toMap((Iterable)elements);
        Integer n = $this$toLeak.getRetainedHeapByteSize();
        if (n == null) {
            string = "unknown size";
        } else {
            int it = ((Number)n).intValue();
            boolean bl = false;
            String string2 = it + " bytes";
            string = string2;
            if (string2 == null) {
                string = "unknown size";
            }
        }
        String string3 = string;
        String string4 = $this$toLeak.getSignature();
        String string5 = (String)((Pair)CollectionsKt.first(elements)).getFirst();
        String string6 = String.valueOf($this$toLeak);
        return new Leak(title, string5, map, string3, string4, string6);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<String, Element>> getElements(LeakTrace $this$getElements) {
        void $this$mapIndexedTo$iv$iv;
        String id;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$getElements.getReferencePath();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void reference;
            LeakTraceReference leakTraceReference = (LeakTraceReference)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            id = string;
            collection.add(TuplesKt.to((Object)id, (Object)new Element(id, reference.getOriginObject())));
        }
        List referenceElements = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        String $i$f$map22 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$map22, (String)"randomUUID().toString()");
        String leakId = $i$f$map22;
        referenceElements.add(TuplesKt.to((Object)leakId, (Object)new Element(leakId, $this$getElements.getLeakingObject())));
        Iterable $this$mapIndexed$iv = referenceElements;
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void pair;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            id = (Pair)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)pair.getFirst(), (Object)(index == CollectionsKt.getLastIndex((List)referenceElements) ? (Element)pair.getSecond() : Element.copy$default((Element)pair.getSecond(), null, null, false, CollectionsKt.listOf((Object)((Element)((Pair)referenceElements.get((int)(index + true))).getSecond()).getId()), null, null, 55, null))));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FlipperArray toFlipperArray(@NotNull Iterable<? extends FlipperObject> $this$toFlipperArray) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$toFlipperArray, (String)"<this>");
        Iterable<? extends FlipperObject> iterable = $this$toFlipperArray;
        FlipperArray.Builder initial$iv = new FlipperArray.Builder();
        boolean $i$f$fold = false;
        FlipperArray.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void row;
            FlipperObject flipperObject = (FlipperObject)element$iv;
            FlipperArray.Builder builder = accumulator$iv;
            boolean bl = false;
            FlipperArray.Builder builder2 = builder.put((FlipperObject)row);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder.put(row)");
            accumulator$iv = builder2;
        }
        FlipperArray flipperArray = accumulator$iv.build();
        Intrinsics.checkNotNullExpressionValue((Object)flipperArray, (String)"fold(FlipperArray.Builde\u2026uilder.put(row) }.build()");
        return flipperArray;
    }

    private static final String getShortName(LeakTraceObject.LeakingStatus $this$shortName) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$shortName.ordinal()]) {
            case 1: {
                string = "N";
                break;
            }
            case 2: {
                string = "Y";
                break;
            }
            case 3: {
                string = "?";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final String getRetaining(LeakTraceObject $this$retaining) {
        String string;
        Integer n = $this$retaining.getRetainedHeapByteSize();
        if (n == null) {
            string = "unknown";
        } else {
            int it = ((Number)n).intValue();
            boolean bl = false;
            String string2 = it + " bytes (" + $this$retaining.getRetainedObjectCount() + " objects)";
            string = string2;
            if (string2 == null) {
                string = "unknown";
            }
        }
        return string;
    }

    public static final /* synthetic */ String access$getShortName(LeakTraceObject.LeakingStatus $receiver) {
        return LeakCanary2ReportKt.getShortName($receiver);
    }

    public static final /* synthetic */ String access$getRetaining(LeakTraceObject $receiver) {
        return LeakCanary2ReportKt.getRetaining($receiver);
    }

    public static final /* synthetic */ FlipperObject access$getEMPTY_FLIPPER_OBJECT$p() {
        return EMPTY_FLIPPER_OBJECT;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LeakTraceObject.LeakingStatus.values().length];
            nArray[LeakTraceObject.LeakingStatus.NOT_LEAKING.ordinal()] = 1;
            nArray[LeakTraceObject.LeakingStatus.LEAKING.ordinal()] = 2;
            nArray[LeakTraceObject.LeakingStatus.UNKNOWN.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

