/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.flipper.plugins.sections;

import com.facebook.flipper.core.FlipperArray;
import com.facebook.flipper.core.FlipperObject;
import com.facebook.litho.sections.Change;
import com.facebook.litho.sections.ChangesInfo;
import com.facebook.litho.sections.ChangesetDebugConfiguration;
import com.facebook.litho.sections.Section;
import com.facebook.litho.sections.SectionsLogEventUtils;
import com.facebook.litho.widget.RenderInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ChangesetDebug
implements ChangesetDebugConfiguration.ChangesetDebugListener {
    private static ChangesetListener sSectionsFlipperPlugin;
    private static ChangesetDebug sInstance;
    private static AtomicInteger sChangesetIdGenerator;

    public static void setListener(ChangesetListener listener) {
        if (sInstance == null) {
            sInstance = new ChangesetDebug(listener);
            ChangesetDebugConfiguration.setListener((ChangesetDebugConfiguration.ChangesetDebugListener)sInstance);
        }
    }

    private ChangesetDebug(ChangesetListener listener) {
        sSectionsFlipperPlugin = listener;
    }

    public void onChangesetApplied(Section rootSection, Section oldSection, ChangesInfo changesInfo, String surfaceId, int source, String attribution) {
    }

    public void onChangesetApplied(Section rootSection, ChangesInfo changesInfo, String surfaceId, ChangesetDebugConfiguration.ChangesetDebugInfo changesetDebugInfo) {
        Section updatedStateSection;
        FlipperArray.Builder tree = new FlipperArray.Builder();
        FlipperObject.Builder changesetData = new FlipperObject.Builder();
        Section oldRootSection = changesetDebugInfo.getOldSection();
        int eventSource = changesetDebugInfo.getSource();
        String attribution = changesetDebugInfo.getAttribution();
        String stateUpdateAttribution = changesetDebugInfo.getUpdateStateAttribution();
        String eventSourceName = SectionsLogEventUtils.applyNewChangeSetSourceToString((int)eventSource);
        ChangesetDebug.extractSidePanelChangesetData(changesInfo, changesetData, rootSection.getGlobalKey());
        ChangesetDebug.createSectionTree(rootSection, tree, oldRootSection, stateUpdateAttribution);
        List<DataModelChangeInfo> prevData = ChangesetDebug.getDataFromPreviousTree(oldRootSection);
        ChangesetDebug.applyChangesInfoOnPreviousData(prevData, changesInfo, tree);
        String eventSourceSection = stateUpdateAttribution == null ? (rootSection == null ? "" : rootSection.getSimpleName()) : ((updatedStateSection = ChangesetDebug.findSectionInPreviousTree(oldRootSection, stateUpdateAttribution)) == null ? "" : updatedStateSection.getSimpleName());
        String stateUpdateMethodName = stateUpdateAttribution == null ? null : attribution;
        sSectionsFlipperPlugin.onChangesetApplied(eventSourceName, eventSourceSection, stateUpdateMethodName, ChangesetDebug.isEventAsync(eventSource), surfaceId, sChangesetIdGenerator.incrementAndGet() + "-" + surfaceId, tree.build(), changesetData.build(), changesetDebugInfo.getStackTrace());
    }

    private static boolean isEventAsync(int source) {
        switch (source) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private static void extractSidePanelChangesetData(ChangesInfo changesInfo, FlipperObject.Builder changesetData, String globalKey) {
        FlipperObject.Builder sectionChangesetInfo = new FlipperObject.Builder();
        List changeList = changesInfo.getAllChanges();
        FlipperObject.Builder changesets = new FlipperObject.Builder();
        for (int i = 0; i < changeList.size(); ++i) {
            Change change = (Change)changeList.get(i);
            FlipperObject.Builder changeData = new FlipperObject.Builder();
            changeData.put("type", Change.changeTypeToString((int)change.getType()));
            changeData.put("index", Integer.valueOf(change.getIndex()));
            if (change.getToIndex() >= 0) {
                changeData.put("toIndex", Integer.valueOf(change.getToIndex()));
            }
            changeData.put("count", Integer.valueOf(change.getCount()));
            changeData.put("render_infos", (Object)ChangesetDebugConfiguration.getRenderInfoNames((Change)change));
            changeData.put("prev_data", (Object)ChangesetDebug.getPrevDataFromChange(change));
            changeData.put("next_data", (Object)ChangesetDebug.getNextDataFromChange(change));
            changesets.put(i + "", changeData.build());
        }
        sectionChangesetInfo.put("changesets", changesets.build());
        changesetData.put(globalKey, sectionChangesetInfo.build());
    }

    private static List getPrevDataFromChange(Change change) {
        if (change.getPrevData() != null) {
            return ChangesetDebug.getDataNamesFromChange(change.getPrevData());
        }
        ArrayList<Object> data = new ArrayList<Object>();
        if (change.getRenderInfo() != null) {
            data.add(change.getRenderInfo().getDebugInfo("SCS_DATA_INFO_PREV"));
        } else if (change.getRenderInfos() != null) {
            for (int i = 0; i < change.getRenderInfos().size(); ++i) {
                data.add(((RenderInfo)change.getRenderInfos().get(i)).getDebugInfo("SCS_DATA_INFO_PREV"));
            }
        }
        return data;
    }

    private static List getNextDataFromChange(Change change) {
        if (change.getNextData() != null) {
            return ChangesetDebug.getDataNamesFromChange(change.getNextData());
        }
        ArrayList<Object> data = new ArrayList<Object>();
        if (change.getRenderInfo() != null) {
            data.add(change.getRenderInfo().getDebugInfo("SCS_DATA_INFO_NEXT"));
        } else if (change.getRenderInfos() != null) {
            for (int i = 0; i < change.getRenderInfos().size(); ++i) {
                data.add(((RenderInfo)change.getRenderInfos().get(i)).getDebugInfo("SCS_DATA_INFO_NEXT"));
            }
        }
        return data;
    }

    private static List<String> getDataNamesFromChange(List<?> data) {
        ArrayList<String> names = new ArrayList<String>();
        if (data == null) {
            return names;
        }
        for (int i = 0; i < data.size(); ++i) {
            names.add(data.get(i).toString());
        }
        return names;
    }

    private static Section findSectionInPreviousTree(Section previousRoot, String globalKey) {
        if (previousRoot == null) {
            return null;
        }
        if (previousRoot.getGlobalKey().equals(globalKey)) {
            return previousRoot;
        }
        if (previousRoot.getChildren() == null) {
            return null;
        }
        int count = previousRoot.getChildren().size();
        for (int i = 0; i < count; ++i) {
            Section child = (Section)previousRoot.getChildren().get(i);
            Section previousSection = ChangesetDebug.findSectionInPreviousTree(child, globalKey);
            if (previousSection == null) continue;
            return previousSection;
        }
        return null;
    }

    private static int getPositionWithChangesApplied(List<DataModelChangeInfo> dataInfos, int operationIndex) {
        int count = -1;
        int i = 0;
        int size = dataInfos.size();
        for (i = 0; i < size; ++i) {
            if (dataInfos.get((int)i).operation != 3 && dataInfos.get((int)i).operation != -3) {
                ++count;
            }
            if (count == operationIndex) break;
        }
        return i;
    }

    private static List getDataFromPreviousSection(Section previousSection) {
        List<Object> data = new ArrayList();
        if (previousSection == null) {
            return data;
        }
        Class<?> clasz = previousSection.getClass();
        String diffSectionType = clasz.getSimpleName();
        try {
            if (diffSectionType.equals("DataDiffSection")) {
                Field field = clasz.getDeclaredField("data");
                field.setAccessible(true);
                data = (List)field.get(previousSection);
            } else if (diffSectionType.equals("SingleComponentSection")) {
                Field field = clasz.getDeclaredField("component");
                field.setAccessible(true);
                data.add(field.get(previousSection));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return data;
    }

    private static void addRemovedSectionNodes(Section previousRoot, Section currentRoot, FlipperArray.Builder tree, String stateUpdateAttribution) {
        Map<String, Section> prevSections = ChangesetDebug.serializeChildren(previousRoot);
        Map<String, Section> currSections = ChangesetDebug.serializeChildren(currentRoot);
        boolean checkStateUpdateTrigger = stateUpdateAttribution != null;
        for (String prevSectionKey : prevSections.keySet()) {
            if (currSections.containsKey(prevSectionKey)) continue;
            FlipperObject.Builder nodeBuilder = new FlipperObject.Builder();
            Section section = prevSections.get(prevSectionKey);
            nodeBuilder.put("identifier", prevSectionKey);
            nodeBuilder.put("name", section.getSimpleName());
            nodeBuilder.put("parent", section.getParent() == null ? null : section.getParent().getGlobalKey());
            nodeBuilder.put("removed", Boolean.valueOf(true));
            nodeBuilder.put("isSection", Boolean.valueOf(true));
            if (checkStateUpdateTrigger && stateUpdateAttribution.equals(prevSectionKey)) {
                nodeBuilder.put("didTriggerStateUpdate", Boolean.valueOf(true));
            }
            tree.put(nodeBuilder.build());
        }
    }

    private static Map<String, Section> serializeChildren(Section root) {
        HashMap<String, Section> children = new HashMap<String, Section>();
        ChangesetDebug.serializeChildrenRecursive(root, children);
        return children;
    }

    private static void serializeChildrenRecursive(Section root, Map<String, Section> children) {
        if (root == null) {
            return;
        }
        children.put(root.getGlobalKey(), root);
        if (root.getChildren() == null) {
            return;
        }
        for (Section child : root.getChildren()) {
            ChangesetDebug.serializeChildrenRecursive(child, children);
        }
    }

    private static List<DataModelChangeInfo> getDataFromPreviousTree(Section previousRoot) {
        ArrayList<DataModelChangeInfo> dataModelChangeInfos = new ArrayList<DataModelChangeInfo>();
        ChangesetDebug.getDataFromPreviousTreeRecursive(previousRoot, dataModelChangeInfos);
        return dataModelChangeInfos;
    }

    private static void getDataFromPreviousTreeRecursive(Section previousRoot, List<DataModelChangeInfo> data) {
        block4: {
            block3: {
                if (previousRoot == null) {
                    return;
                }
                if (!previousRoot.isDiffSectionSpec()) break block3;
                List models = ChangesetDebug.getDataFromPreviousSection(previousRoot);
                for (int i = 0; i < models.size(); ++i) {
                    DataModelChangeInfo dataModelChangeInfo = new DataModelChangeInfo();
                    dataModelChangeInfo.model = models.get(i);
                    dataModelChangeInfo.sectionKey = previousRoot.getGlobalKey();
                    data.add(dataModelChangeInfo);
                }
                break block4;
            }
            if (previousRoot.getChildren() == null) break block4;
            for (Section child : previousRoot.getChildren()) {
                ChangesetDebug.getDataFromPreviousTreeRecursive(child, data);
            }
        }
    }

    private static void applyChangesInfoOnPreviousData(List<DataModelChangeInfo> dataInfos, ChangesInfo changesInfo, FlipperArray.Builder tree) {
        int i;
        List changes = changesInfo.getAllChanges();
        block8: for (i = 0; i < changes.size(); ++i) {
            Change change = (Change)changes.get(i);
            int index = change.getIndex();
            switch (change.getType()) {
                case 1: {
                    DataModelChangeInfo dataInfo = new DataModelChangeInfo();
                    dataInfo.model = change.getNextData() != null ? change.getNextData().get(0) : ChangesetDebug.getNextDataFromChange(change);
                    dataInfo.sectionKey = (String)change.getRenderInfo().getDebugInfo("section_global_key");
                    dataInfo.operation = 1;
                    int addToPosition = ChangesetDebug.getPositionWithChangesApplied(dataInfos, index);
                    dataInfos.add(addToPosition, dataInfo);
                    continue block8;
                }
                case -1: {
                    DataModelChangeInfo dataInfo;
                    int addToPosition = ChangesetDebug.getPositionWithChangesApplied(dataInfos, index);
                    for (int item = 0; item < change.getCount(); ++item) {
                        dataInfo = new DataModelChangeInfo();
                        dataInfo.model = change.getNextData() != null ? change.getNextData().get(item) : ChangesetDebug.getNextDataFromChange(change);
                        dataInfo.operation = -1;
                        dataInfo.sectionKey = (String)((RenderInfo)change.getRenderInfos().get(item)).getDebugInfo("section_global_key");
                        dataInfos.add(addToPosition + item, dataInfo);
                    }
                    continue block8;
                }
                case 3: {
                    int addToPosition = ChangesetDebug.getPositionWithChangesApplied(dataInfos, index);
                    DataModelChangeInfo dataInfo = dataInfos.get(addToPosition);
                    dataInfo.operation = 3;
                    continue block8;
                }
                case -3: {
                    int addToPosition;
                    for (int del = addToPosition = ChangesetDebug.getPositionWithChangesApplied(dataInfos, index); del < addToPosition + change.getCount(); ++del) {
                        dataInfos.get((int)del).operation = -3;
                    }
                    continue block8;
                }
                case 2: {
                    int getPosition = ChangesetDebug.getPositionWithChangesApplied(dataInfos, index);
                    DataModelChangeInfo dataInfo = dataInfos.get(getPosition);
                    dataInfo.operation = 2;
                    dataInfo.model = ChangesetDebug.getNextDataFromChange(change);
                    continue block8;
                }
                case -2: {
                    DataModelChangeInfo dataInfo;
                    for (int updateIndex = index; updateIndex < index + change.getCount(); ++updateIndex) {
                        int getPosition = ChangesetDebug.getPositionWithChangesApplied(dataInfos, updateIndex);
                        dataInfo = dataInfos.get(getPosition);
                        dataInfo.operation = -2;
                        dataInfo.model = ChangesetDebug.getNextDataFromChange(change);
                    }
                    continue block8;
                }
            }
        }
        for (i = 0; i < dataInfos.size(); ++i) {
            DataModelChangeInfo dataInfo = dataInfos.get(i);
            FlipperObject.Builder dataObject = new FlipperObject.Builder();
            String name = dataInfo.model == null ? "N/A" : dataInfo.model.toString();
            int operation = dataInfo.operation;
            dataObject.put("identifier", name);
            dataObject.put("name", name);
            dataObject.put("parent", dataInfo.sectionKey);
            dataObject.put("unchanged", Boolean.valueOf(operation == -100));
            dataObject.put("inserted", Boolean.valueOf(operation == 1 || operation == -1));
            dataObject.put("removed", Boolean.valueOf(operation == 3 || operation == -3));
            dataObject.put("updated", Boolean.valueOf(operation == 2 || operation == -2));
            dataObject.put("isDataModel", Boolean.valueOf(true));
            tree.put(dataObject.build());
        }
    }

    private static void createSectionTree(Section rootSection, FlipperArray.Builder tree, Section oldRootSection, String stateUpdateAttribution) {
        ChangesetDebug.createSectionTreeRecursive(rootSection, "", tree, oldRootSection, 0, stateUpdateAttribution);
        ChangesetDebug.addRemovedSectionNodes(oldRootSection, rootSection, tree, stateUpdateAttribution);
    }

    private static void createSectionTreeRecursive(Section rootSection, String parentKey, FlipperArray.Builder tree, Section oldRootSection, int startIndex, String stateUpdateAttribution) {
        if (rootSection == null) {
            return;
        }
        int endIndex = startIndex + ChangesetDebugConfiguration.getSectionCount((Section)rootSection) - 1;
        String name = "[" + startIndex + ", " + endIndex + "] " + rootSection.getSimpleName();
        String globalKey = rootSection.getGlobalKey();
        FlipperObject.Builder nodeBuilder = new FlipperObject.Builder();
        Section oldSection = ChangesetDebug.findSectionInPreviousTree(oldRootSection, globalKey);
        boolean isDirty = ChangesetDebugConfiguration.isSectionDirty((Section)oldSection, (Section)rootSection);
        boolean triggeredStateUpdate = stateUpdateAttribution != null && stateUpdateAttribution.equals(globalKey);
        nodeBuilder.put("identifier", globalKey);
        nodeBuilder.put("name", name);
        nodeBuilder.put("parent", parentKey);
        nodeBuilder.put("isDirty", Boolean.valueOf(isDirty));
        nodeBuilder.put("isReused", Boolean.valueOf(!isDirty));
        nodeBuilder.put("didTriggerStateUpdate", Boolean.valueOf(triggeredStateUpdate));
        nodeBuilder.put("isSection", Boolean.valueOf(true));
        tree.put(nodeBuilder.build());
        if (rootSection.getChildren() == null) {
            return;
        }
        for (int i = 0; i < rootSection.getChildren().size(); ++i) {
            if (i > 0) {
                startIndex += ChangesetDebugConfiguration.getSectionCount((Section)((Section)rootSection.getChildren().get(i - 1)));
            }
            ChangesetDebug.createSectionTreeRecursive((Section)rootSection.getChildren().get(i), globalKey, tree, oldRootSection, startIndex, stateUpdateAttribution);
        }
    }

    static {
        sChangesetIdGenerator = new AtomicInteger();
    }

    private static class DataModelChangeInfo {
        static final int UNCHANGED = -100;
        Object model;
        int operation = -100;
        String sectionKey;

        private DataModelChangeInfo() {
        }
    }

    public static interface ChangesetListener {
        public void onChangesetApplied(String var1, String var2, String var3, boolean var4, String var5, String var6, FlipperArray var7, FlipperObject var8, StackTraceElement[] var9);
    }
}

