/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.flipper.plugins.sections;

import com.facebook.flipper.core.FlipperArray;
import com.facebook.flipper.core.FlipperConnection;
import com.facebook.flipper.core.FlipperObject;
import com.facebook.flipper.core.FlipperPlugin;
import com.facebook.flipper.plugins.sections.ChangesetDebug;

public class SectionsFlipperPlugin
implements FlipperPlugin,
ChangesetDebug.ChangesetListener {
    private final boolean mEnableDebugging;
    private FlipperConnection mConnection;

    public SectionsFlipperPlugin(boolean enableDebugging) {
        this.mEnableDebugging = enableDebugging;
    }

    public String getId() {
        return "Sections";
    }

    public void onConnect(FlipperConnection connection) throws Exception {
        if (!this.mEnableDebugging) {
            return;
        }
        this.mConnection = connection;
        ChangesetDebug.setListener(this);
    }

    public void onDisconnect() throws Exception {
    }

    public boolean runInBackground() {
        return false;
    }

    @Override
    public void onChangesetApplied(String eventName, String eventSource, String updateStateMethodName, boolean isAsync, String surfaceId, String id, FlipperArray tree, FlipperObject changesetData, StackTraceElement[] trace) {
        if (this.mConnection == null) {
            return;
        }
        String reason = eventName + " " + eventSource;
        FlipperObject.Builder eventPayloadBuilder = new FlipperObject.Builder();
        eventPayloadBuilder.put("Event", eventName);
        eventPayloadBuilder.put("Async", Boolean.valueOf(isAsync));
        eventPayloadBuilder.put("Section", eventSource);
        if (updateStateMethodName != null) {
            eventPayloadBuilder.put("Update state method", updateStateMethodName);
        }
        this.mConnection.send("addEvent", new FlipperObject.Builder().put("id", id).put("update_mode", Integer.valueOf(isAsync ? 0 : 1)).put("reason", reason).put("surface_key", surfaceId).put("tree_generation_timestamp", Integer.valueOf(10000)).put("payload", new FlipperObject.Builder().build()).put("stack_trace", this.getStackTrace(trace)).put("skip_stack_trace_format", Boolean.valueOf(true)).put("payload", eventPayloadBuilder.build()).build());
        this.mConnection.send("updateTreeGenerationHierarchyGeneration", new FlipperObject.Builder().put("id", id).put("hierarchy_generation_timestamp", Integer.valueOf(10000)).put("hierarchy_generation_duration", Integer.valueOf(0)).put("tree", tree).put("reason", eventName).build());
        this.mConnection.send("updateTreeGenerationChangesetGeneration", new FlipperObject.Builder().put("type", "CHANGESET_GENERATED").put("identifier", id).put("tree_generation_id", "" + id).put("timestamp", Integer.valueOf(10000)).put("duration", Integer.valueOf(0)).put("changeset", changesetData).build());
        this.mConnection.send("updateTreeGenerationChangesetApplication", new FlipperObject.Builder().put("type", "CHANGESET_APPLIED").put("identifier", id).put("tree_generation_id", id).put("timestamp", Integer.valueOf(10000)).put("duration", Integer.valueOf(0)).put("changeset", changesetData).build());
    }

    private FlipperArray getStackTrace(StackTraceElement[] trace) {
        FlipperArray.Builder builder = new FlipperArray.Builder();
        for (StackTraceElement element : trace) {
            builder.put(element.toString() + "\n");
        }
        return builder.build();
    }
}

