/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.flipper.plugins.network;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public interface NetworkReporter {
    public void reportRequest(RequestInfo var1);

    public void reportResponse(ResponseInfo var1);

    public static class ResponseInfo {
        public String requestId;
        public long timeStamp;
        public int statusCode;
        public String statusReason;
        public List<Header> headers = new ArrayList<Header>();
        @Nullable
        public byte[] body;
        public boolean isMock = false;

        public Header getFirstHeader(String name) {
            for (Header header : this.headers) {
                if (!name.equalsIgnoreCase(header.name)) continue;
                return header;
            }
            return null;
        }
    }

    public static class RequestInfo {
        public String requestId;
        public long timeStamp;
        public List<Header> headers = new ArrayList<Header>();
        public String method;
        public String uri;
        public byte[] body;
        public String videoId = null;

        public Header getFirstHeader(String name) {
            for (Header header : this.headers) {
                if (!name.equalsIgnoreCase(header.name)) continue;
                return header;
            }
            return null;
        }
    }

    public static class Header {
        public final String name;
        public final String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "Header{" + this.name + ": " + this.value + "}";
        }
    }
}

