/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.flipper.plugins.network;

import android.text.TextUtils;
import android.util.Pair;
import com.facebook.flipper.core.FlipperArray;
import com.facebook.flipper.core.FlipperConnection;
import com.facebook.flipper.core.FlipperObject;
import com.facebook.flipper.core.FlipperReceiver;
import com.facebook.flipper.core.FlipperResponder;
import com.facebook.flipper.plugins.common.BufferingFlipperPlugin;
import com.facebook.flipper.plugins.network.NetworkFlipperPlugin;
import com.facebook.flipper.plugins.network.NetworkReporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;

public class FlipperOkhttpInterceptor
implements Interceptor,
BufferingFlipperPlugin.MockResponseConnectionListener {
    private static final long DEFAULT_MAX_BODY_BYTES = 102400L;
    private final long mMaxBodyBytes;
    private final NetworkFlipperPlugin mPlugin;
    private Map<PartialRequestInfo, NetworkReporter.ResponseInfo> mMockResponseMap = new HashMap<PartialRequestInfo, NetworkReporter.ResponseInfo>(0);
    private boolean mIsMockResponseSupported;

    public FlipperOkhttpInterceptor(NetworkFlipperPlugin plugin) {
        this(plugin, 102400L, false);
    }

    public FlipperOkhttpInterceptor(NetworkFlipperPlugin plugin, long maxBodyBytes) {
        this(plugin, maxBodyBytes, false);
    }

    public FlipperOkhttpInterceptor(NetworkFlipperPlugin plugin, boolean isMockResponseSupported) {
        this(plugin, 102400L, isMockResponseSupported);
    }

    public FlipperOkhttpInterceptor(NetworkFlipperPlugin plugin, long maxBodyBytes, boolean isMockResponseSupported) {
        this.mPlugin = plugin;
        this.mMaxBodyBytes = maxBodyBytes;
        this.mIsMockResponseSupported = isMockResponseSupported;
        if (isMockResponseSupported) {
            this.mPlugin.setConnectionListener(this);
        }
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Pair<Request, Buffer> requestWithClonedBody = FlipperOkhttpInterceptor.cloneBodyAndInvalidateRequest(request);
        request = (Request)requestWithClonedBody.first;
        String identifier = UUID.randomUUID().toString();
        this.mPlugin.reportRequest(this.convertRequest(request, (Buffer)requestWithClonedBody.second, identifier));
        Response mockResponse = this.mIsMockResponseSupported ? this.getMockResponse(request) : null;
        Response response = mockResponse != null ? mockResponse : chain.proceed(request);
        Buffer responseBody = FlipperOkhttpInterceptor.cloneBodyForResponse(response, this.mMaxBodyBytes);
        NetworkReporter.ResponseInfo responseInfo = this.convertResponse(response, responseBody, identifier, mockResponse != null);
        this.mPlugin.reportResponse(responseInfo);
        return response;
    }

    private static byte[] bodyBufferToByteArray(Buffer bodyBuffer, long maxBodyBytes) throws IOException {
        return bodyBuffer.readByteArray(Math.min(bodyBuffer.size(), maxBodyBytes));
    }

    private static Pair<Request, Buffer> cloneBodyAndInvalidateRequest(Request request) throws IOException {
        if (request.body() != null) {
            Request.Builder builder = request.newBuilder();
            MediaType mediaType = request.body().contentType();
            Buffer originalBuffer = new Buffer();
            request.body().writeTo((BufferedSink)originalBuffer);
            Buffer clonedBuffer = originalBuffer.clone();
            RequestBody newOriginalBody = RequestBody.create((MediaType)mediaType, (ByteString)originalBuffer.readByteString());
            return new Pair((Object)builder.method(request.method(), newOriginalBody).build(), (Object)clonedBuffer);
        }
        return new Pair((Object)request, null);
    }

    private NetworkReporter.RequestInfo convertRequest(Request request, Buffer bodyBuffer, String identifier) throws IOException {
        List<NetworkReporter.Header> headers = FlipperOkhttpInterceptor.convertHeader(request.headers());
        NetworkReporter.RequestInfo info = new NetworkReporter.RequestInfo();
        info.requestId = identifier;
        info.timeStamp = System.currentTimeMillis();
        info.headers = headers;
        info.method = request.method();
        info.uri = request.url().toString();
        if (bodyBuffer != null) {
            info.body = FlipperOkhttpInterceptor.bodyBufferToByteArray(bodyBuffer, this.mMaxBodyBytes);
            bodyBuffer.close();
        }
        return info;
    }

    private static Buffer cloneBodyForResponse(Response response, long maxBodyBytes) throws IOException {
        if (response.body() != null && response.body().source() != null && response.body().source().buffer() != null) {
            BufferedSource source = response.body().source();
            source.request(maxBodyBytes);
            return source.buffer().clone();
        }
        return null;
    }

    private NetworkReporter.ResponseInfo convertResponse(Response response, Buffer bodyBuffer, String identifier, boolean isMock) throws IOException {
        List<NetworkReporter.Header> headers = FlipperOkhttpInterceptor.convertHeader(response.headers());
        NetworkReporter.ResponseInfo info = new NetworkReporter.ResponseInfo();
        info.requestId = identifier;
        info.timeStamp = response.receivedResponseAtMillis();
        info.statusCode = response.code();
        info.headers = headers;
        info.isMock = isMock;
        if (bodyBuffer != null) {
            info.body = FlipperOkhttpInterceptor.bodyBufferToByteArray(bodyBuffer, this.mMaxBodyBytes);
            bodyBuffer.close();
        }
        return info;
    }

    private static List<NetworkReporter.Header> convertHeader(Headers headers) {
        ArrayList<NetworkReporter.Header> list = new ArrayList<NetworkReporter.Header>(headers.size());
        Set keys = headers.names();
        for (String key : keys) {
            list.add(new NetworkReporter.Header(key, headers.get(key)));
        }
        return list;
    }

    private void registerMockResponse(PartialRequestInfo partialRequest, NetworkReporter.ResponseInfo response) {
        if (!this.mMockResponseMap.containsKey((Object)partialRequest)) {
            this.mMockResponseMap.put(partialRequest, response);
        }
    }

    @Nullable
    private Response getMockResponse(Request request) {
        String method;
        String url = request.url().toString();
        PartialRequestInfo partialRequest = new PartialRequestInfo(url, method = request.method());
        if (!this.mMockResponseMap.containsKey((Object)partialRequest)) {
            return null;
        }
        NetworkReporter.ResponseInfo mockResponse = this.mMockResponseMap.get((Object)partialRequest);
        if (mockResponse == null) {
            return null;
        }
        Response.Builder builder = new Response.Builder();
        builder.request(request).protocol(Protocol.HTTP_1_1).code(mockResponse.statusCode).message(mockResponse.statusReason).receivedResponseAtMillis(System.currentTimeMillis()).body(ResponseBody.create((MediaType)MediaType.parse((String)"application/text"), (byte[])mockResponse.body));
        if (mockResponse.headers != null && !mockResponse.headers.isEmpty()) {
            for (NetworkReporter.Header header : mockResponse.headers) {
                if (TextUtils.isEmpty((CharSequence)header.name) || TextUtils.isEmpty((CharSequence)header.value)) continue;
                builder.header(header.name, header.value);
            }
        }
        return builder.build();
    }

    @Nullable
    private NetworkReporter.ResponseInfo convertFlipperObjectRouteToResponseInfo(FlipperObject route) {
        String data = route.getString("data");
        String requestUrl = route.getString("requestUrl");
        String method = route.getString("method");
        FlipperArray headersArray = route.getArray("headers");
        if (TextUtils.isEmpty((CharSequence)requestUrl) || TextUtils.isEmpty((CharSequence)method)) {
            return null;
        }
        int statusCode = route.getInt("status");
        NetworkReporter.ResponseInfo mockResponse = new NetworkReporter.ResponseInfo();
        mockResponse.body = data.getBytes();
        mockResponse.statusCode = 200;
        mockResponse.statusCode = statusCode;
        mockResponse.statusReason = "OK";
        if (headersArray != null) {
            ArrayList<NetworkReporter.Header> headers = new ArrayList<NetworkReporter.Header>();
            for (int j = 0; j < headersArray.length(); ++j) {
                FlipperObject header = headersArray.getObject(j);
                headers.add(new NetworkReporter.Header(header.getString("key"), header.getString("value")));
            }
            mockResponse.headers = headers;
        }
        return mockResponse;
    }

    public void onConnect(FlipperConnection connection) {
        connection.receive("mockResponses", new FlipperReceiver(){

            public void onReceive(FlipperObject params, FlipperResponder responder) throws Exception {
                FlipperArray array = params.getArray("routes");
                FlipperOkhttpInterceptor.this.mMockResponseMap.clear();
                for (int i = 0; i < array.length(); ++i) {
                    FlipperObject route = array.getObject(i);
                    String requestUrl = route.getString("requestUrl");
                    String method = route.getString("method");
                    NetworkReporter.ResponseInfo mockResponse = FlipperOkhttpInterceptor.this.convertFlipperObjectRouteToResponseInfo(route);
                    if (mockResponse == null) continue;
                    FlipperOkhttpInterceptor.this.registerMockResponse(new PartialRequestInfo(requestUrl, method), mockResponse);
                }
                responder.success();
            }
        });
    }

    public void onDisconnect() {
        this.mMockResponseMap.clear();
    }

    private static class PartialRequestInfo
    extends Pair<String, String> {
        PartialRequestInfo(String url, String method) {
            super((Object)url, (Object)method);
        }
    }
}

