/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.wrapper;

import android.graphics.Bitmap;
import android.graphics.Rect;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.impl.AnimatedImageCompositor;
import javax.annotation.Nullable;

public class AnimatedDrawableBackendFrameRenderer
implements BitmapFrameRenderer {
    private static final Class<?> TAG = AnimatedDrawableBackendFrameRenderer.class;
    private final BitmapFrameCache mBitmapFrameCache;
    private AnimatedDrawableBackend mAnimatedDrawableBackend;
    private AnimatedImageCompositor mAnimatedImageCompositor;
    private final AnimatedImageCompositor.Callback mCallback = new AnimatedImageCompositor.Callback(){

        @Override
        public void onIntermediateResult(int frameNumber, Bitmap bitmap) {
        }

        @Override
        @Nullable
        public CloseableReference<Bitmap> getCachedBitmap(int frameNumber) {
            return AnimatedDrawableBackendFrameRenderer.this.mBitmapFrameCache.getCachedFrame(frameNumber);
        }
    };

    public AnimatedDrawableBackendFrameRenderer(BitmapFrameCache bitmapFrameCache, AnimatedDrawableBackend animatedDrawableBackend) {
        this.mBitmapFrameCache = bitmapFrameCache;
        this.mAnimatedDrawableBackend = animatedDrawableBackend;
        this.mAnimatedImageCompositor = new AnimatedImageCompositor(this.mAnimatedDrawableBackend, this.mCallback);
    }

    public void setBounds(@Nullable Rect bounds) {
        AnimatedDrawableBackend newBackend = this.mAnimatedDrawableBackend.forNewBounds(bounds);
        if (newBackend != this.mAnimatedDrawableBackend) {
            this.mAnimatedDrawableBackend = newBackend;
            this.mAnimatedImageCompositor = new AnimatedImageCompositor(this.mAnimatedDrawableBackend, this.mCallback);
        }
    }

    public int getIntrinsicWidth() {
        return this.mAnimatedDrawableBackend.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.mAnimatedDrawableBackend.getHeight();
    }

    public boolean renderFrame(int frameNumber, Bitmap targetBitmap) {
        try {
            this.mAnimatedImageCompositor.renderFrame(frameNumber, targetBitmap);
        }
        catch (IllegalStateException exception) {
            FLog.e(TAG, (Throwable)exception, (String)"Rendering of frame unsuccessful. Frame number: %d", (Object[])new Object[]{frameNumber});
            return false;
        }
        return true;
    }
}

