/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.factory;

import android.content.Context;
import android.graphics.Rect;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.executors.DefaultSerialExecutorService;
import com.facebook.common.executors.SerialExecutorService;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Supplier;
import com.facebook.common.internal.Suppliers;
import com.facebook.common.time.MonotonicClock;
import com.facebook.common.time.RealtimeSinceBootClock;
import com.facebook.fresco.animation.factory.ExperimentalBitmapAnimationDrawableFactory;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.animated.factory.AnimatedFactory;
import com.facebook.imagepipeline.animated.factory.AnimatedImageFactory;
import com.facebook.imagepipeline.animated.factory.AnimatedImageFactoryImpl;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendImpl;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendProvider;
import com.facebook.imagepipeline.animated.util.AnimatedDrawableUtil;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.core.ExecutorSupplier;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.drawable.DrawableFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.infer.annotation.Nullsafe;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@NotThreadSafe
@DoNotStrip
public class AnimatedFactoryV2Impl
implements AnimatedFactory {
    private static final int NUMBER_OF_FRAMES_TO_PREPARE = 3;
    private final PlatformBitmapFactory mPlatformBitmapFactory;
    private final ExecutorSupplier mExecutorSupplier;
    private final CountingMemoryCache<CacheKey, CloseableImage> mBackingCache;
    private final boolean mDownscaleFrameToDrawableDimensions;
    @Nullable
    private AnimatedImageFactory mAnimatedImageFactory;
    @Nullable
    private AnimatedDrawableBackendProvider mAnimatedDrawableBackendProvider;
    @Nullable
    private AnimatedDrawableUtil mAnimatedDrawableUtil;
    @Nullable
    private DrawableFactory mAnimatedDrawableFactory;
    @Nullable
    private SerialExecutorService mSerialExecutorService;

    @DoNotStrip
    public AnimatedFactoryV2Impl(PlatformBitmapFactory platformBitmapFactory, ExecutorSupplier executorSupplier, CountingMemoryCache<CacheKey, CloseableImage> backingCache, boolean downscaleFrameToDrawableDimensions, SerialExecutorService serialExecutorServiceForFramePreparing) {
        this.mPlatformBitmapFactory = platformBitmapFactory;
        this.mExecutorSupplier = executorSupplier;
        this.mBackingCache = backingCache;
        this.mDownscaleFrameToDrawableDimensions = downscaleFrameToDrawableDimensions;
        this.mSerialExecutorService = serialExecutorServiceForFramePreparing;
    }

    @Nullable
    public DrawableFactory getAnimatedDrawableFactory(@Nullable Context context) {
        if (this.mAnimatedDrawableFactory == null) {
            this.mAnimatedDrawableFactory = this.createDrawableFactory();
        }
        return this.mAnimatedDrawableFactory;
    }

    public ImageDecoder getGifDecoder() {
        return new ImageDecoder(){

            public CloseableImage decode(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
                return AnimatedFactoryV2Impl.this.getAnimatedImageFactory().decodeGif(encodedImage, options, options.animatedBitmapConfig);
            }
        };
    }

    public ImageDecoder getWebPDecoder() {
        return new ImageDecoder(){

            public CloseableImage decode(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
                return AnimatedFactoryV2Impl.this.getAnimatedImageFactory().decodeWebP(encodedImage, options, options.animatedBitmapConfig);
            }
        };
    }

    private ExperimentalBitmapAnimationDrawableFactory createDrawableFactory() {
        Supplier<Integer> cachingStrategySupplier = new Supplier<Integer>(){

            public Integer get() {
                return 2;
            }
        };
        DefaultSerialExecutorService serialExecutorServiceForFramePreparing = this.mSerialExecutorService == null ? new DefaultSerialExecutorService(this.mExecutorSupplier.forDecode()) : this.mSerialExecutorService;
        Supplier<Integer> numberOfFramesToPrepareSupplier = new Supplier<Integer>(){

            public Integer get() {
                return 3;
            }
        };
        Supplier useDeepEquals = Suppliers.BOOLEAN_FALSE;
        return new ExperimentalBitmapAnimationDrawableFactory(this.getAnimatedDrawableBackendProvider(), (ScheduledExecutorService)UiThreadImmediateExecutorService.getInstance(), (ExecutorService)serialExecutorServiceForFramePreparing, (MonotonicClock)RealtimeSinceBootClock.get(), this.mPlatformBitmapFactory, this.mBackingCache, cachingStrategySupplier, numberOfFramesToPrepareSupplier, (Supplier<Boolean>)useDeepEquals);
    }

    private AnimatedDrawableUtil getAnimatedDrawableUtil() {
        if (this.mAnimatedDrawableUtil == null) {
            this.mAnimatedDrawableUtil = new AnimatedDrawableUtil();
        }
        return this.mAnimatedDrawableUtil;
    }

    private AnimatedImageFactory getAnimatedImageFactory() {
        if (this.mAnimatedImageFactory == null) {
            this.mAnimatedImageFactory = this.buildAnimatedImageFactory();
        }
        return this.mAnimatedImageFactory;
    }

    private AnimatedDrawableBackendProvider getAnimatedDrawableBackendProvider() {
        if (this.mAnimatedDrawableBackendProvider == null) {
            this.mAnimatedDrawableBackendProvider = new AnimatedDrawableBackendProvider(){

                @Override
                public AnimatedDrawableBackend get(AnimatedImageResult animatedImageResult, @Nullable Rect bounds) {
                    return new AnimatedDrawableBackendImpl(AnimatedFactoryV2Impl.this.getAnimatedDrawableUtil(), animatedImageResult, bounds, AnimatedFactoryV2Impl.this.mDownscaleFrameToDrawableDimensions);
                }
            };
        }
        return this.mAnimatedDrawableBackendProvider;
    }

    private AnimatedImageFactory buildAnimatedImageFactory() {
        AnimatedDrawableBackendProvider animatedDrawableBackendProvider = new AnimatedDrawableBackendProvider(){

            @Override
            public AnimatedDrawableBackend get(AnimatedImageResult imageResult, @Nullable Rect bounds) {
                return new AnimatedDrawableBackendImpl(AnimatedFactoryV2Impl.this.getAnimatedDrawableUtil(), imageResult, bounds, AnimatedFactoryV2Impl.this.mDownscaleFrameToDrawableDimensions);
            }
        };
        return new AnimatedImageFactoryImpl(animatedDrawableBackendProvider, this.mPlatformBitmapFactory);
    }
}

