/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.impl;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.transformation.BitmapTransformation;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class AnimatedImageCompositor {
    private final AnimatedDrawableBackend mAnimatedDrawableBackend;
    private final Callback mCallback;
    private final Paint mTransparentFillPaint;
    private final boolean mIsNewRenderImplementation;

    public AnimatedImageCompositor(AnimatedDrawableBackend animatedDrawableBackend, boolean isNewRenderImplementation, Callback callback) {
        this.mAnimatedDrawableBackend = animatedDrawableBackend;
        this.mCallback = callback;
        this.mIsNewRenderImplementation = isNewRenderImplementation;
        this.mTransparentFillPaint = new Paint();
        this.mTransparentFillPaint.setColor(0);
        this.mTransparentFillPaint.setStyle(Paint.Style.FILL);
        this.mTransparentFillPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
    }

    public void renderDeltas(int frameNumber, Bitmap baseBitmap) {
        Canvas canvas = new Canvas(baseBitmap);
        this.mAnimatedDrawableBackend.renderDeltas(frameNumber, canvas);
    }

    public void renderFrame(int frameNumber, Bitmap bitmap) {
        if (this.mIsNewRenderImplementation) {
            this.renderDeltas(frameNumber, bitmap);
            return;
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0, PorterDuff.Mode.SRC);
        int nextIndex = !this.isKeyFrame(frameNumber) ? this.prepareCanvasWithClosestCachedFrame(frameNumber - 1, canvas) : frameNumber;
        for (int index = nextIndex; index < frameNumber; ++index) {
            AnimatedDrawableFrameInfo frameInfo = this.mAnimatedDrawableBackend.getFrameInfo(index);
            AnimatedDrawableFrameInfo.DisposalMethod disposalMethod = frameInfo.disposalMethod;
            if (disposalMethod == AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_PREVIOUS) continue;
            if (frameInfo.blendOperation == AnimatedDrawableFrameInfo.BlendOperation.NO_BLEND) {
                this.disposeToBackground(canvas, frameInfo);
            }
            this.mAnimatedDrawableBackend.renderFrame(index, canvas);
            this.mCallback.onIntermediateResult(index, bitmap);
            if (disposalMethod != AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND) continue;
            this.disposeToBackground(canvas, frameInfo);
        }
        AnimatedDrawableFrameInfo frameInfo = this.mAnimatedDrawableBackend.getFrameInfo(frameNumber);
        if (frameInfo.blendOperation == AnimatedDrawableFrameInfo.BlendOperation.NO_BLEND) {
            this.disposeToBackground(canvas, frameInfo);
        }
        this.mAnimatedDrawableBackend.renderFrame(frameNumber, canvas);
        this.maybeApplyTransformation(bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareCanvasWithClosestCachedFrame(int previousFrameNumber, Canvas canvas) {
        block8: for (int index = previousFrameNumber; index >= 0; --index) {
            FrameNeededResult neededResult = this.isFrameNeededForRendering(index);
            switch (neededResult) {
                case REQUIRED: {
                    AnimatedDrawableFrameInfo frameInfo = this.mAnimatedDrawableBackend.getFrameInfo(index);
                    CloseableReference<Bitmap> startBitmap = this.mCallback.getCachedBitmap(index);
                    if (startBitmap != null) {
                        try {
                            canvas.drawBitmap((Bitmap)startBitmap.get(), 0.0f, 0.0f, null);
                            if (frameInfo.disposalMethod == AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND) {
                                this.disposeToBackground(canvas, frameInfo);
                            }
                            int n = index + 1;
                            return n;
                        }
                        finally {
                            if (!this.mIsNewRenderImplementation) {
                                startBitmap.close();
                            }
                        }
                    }
                    if (!this.isKeyFrame(index)) continue block8;
                    return index;
                }
                case NOT_REQUIRED: {
                    return index + 1;
                }
                case ABORT: {
                    return index;
                }
            }
        }
        return 0;
    }

    private void disposeToBackground(Canvas canvas, AnimatedDrawableFrameInfo frameInfo) {
        canvas.drawRect((float)frameInfo.xOffset, (float)frameInfo.yOffset, (float)(frameInfo.xOffset + frameInfo.width), (float)(frameInfo.yOffset + frameInfo.height), this.mTransparentFillPaint);
    }

    private FrameNeededResult isFrameNeededForRendering(int index) {
        AnimatedDrawableFrameInfo frameInfo = this.mAnimatedDrawableBackend.getFrameInfo(index);
        AnimatedDrawableFrameInfo.DisposalMethod disposalMethod = frameInfo.disposalMethod;
        if (disposalMethod == AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT) {
            return FrameNeededResult.REQUIRED;
        }
        if (disposalMethod == AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND) {
            if (this.isFullFrame(frameInfo)) {
                return FrameNeededResult.NOT_REQUIRED;
            }
            return FrameNeededResult.REQUIRED;
        }
        if (disposalMethod == AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_PREVIOUS) {
            return FrameNeededResult.SKIP;
        }
        return FrameNeededResult.ABORT;
    }

    private boolean isKeyFrame(int index) {
        if (index == 0) {
            return true;
        }
        AnimatedDrawableFrameInfo currFrameInfo = this.mAnimatedDrawableBackend.getFrameInfo(index);
        AnimatedDrawableFrameInfo prevFrameInfo = this.mAnimatedDrawableBackend.getFrameInfo(index - 1);
        if (currFrameInfo.blendOperation == AnimatedDrawableFrameInfo.BlendOperation.NO_BLEND && this.isFullFrame(currFrameInfo)) {
            return true;
        }
        return prevFrameInfo.disposalMethod == AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND && this.isFullFrame(prevFrameInfo);
    }

    private boolean isFullFrame(AnimatedDrawableFrameInfo frameInfo) {
        return frameInfo.xOffset == 0 && frameInfo.yOffset == 0 && frameInfo.width == this.mAnimatedDrawableBackend.getRenderedWidth() && frameInfo.height == this.mAnimatedDrawableBackend.getRenderedHeight();
    }

    private void maybeApplyTransformation(Bitmap bitmap) {
        AnimatedImageResult animatedImageResult = this.mAnimatedDrawableBackend.getAnimatedImageResult();
        if (animatedImageResult == null) {
            return;
        }
        BitmapTransformation tr = animatedImageResult.getBitmapTransformation();
        if (tr == null) {
            return;
        }
        tr.transform(bitmap);
    }

    public static interface Callback {
        public void onIntermediateResult(int var1, Bitmap var2);

        @Nullable
        public CloseableReference<Bitmap> getCachedBitmap(int var1);
    }

    private static enum FrameNeededResult {
        REQUIRED,
        NOT_REQUIRED,
        SKIP,
        ABORT;

    }
}

