/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.wrapper;

import android.graphics.Bitmap;
import android.graphics.Rect;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.impl.AnimatedImageCompositor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/facebook/fresco/animation/bitmap/wrapper/AnimatedDrawableBackendFrameRenderer;", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;", "bitmapFrameCache", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache;", "animatedDrawableBackend", "Lcom/facebook/imagepipeline/animated/base/AnimatedDrawableBackend;", "isNewRenderImplementation", "", "<init>", "(Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache;Lcom/facebook/imagepipeline/animated/base/AnimatedDrawableBackend;Z)V", "animatedImageCompositor", "Lcom/facebook/imagepipeline/animated/impl/AnimatedImageCompositor;", "callback", "Lcom/facebook/imagepipeline/animated/impl/AnimatedImageCompositor$Callback;", "setBounds", "", "bounds", "Landroid/graphics/Rect;", "intrinsicWidth", "", "getIntrinsicWidth", "()I", "intrinsicHeight", "getIntrinsicHeight", "renderFrame", "frameNumber", "targetBitmap", "Landroid/graphics/Bitmap;", "Companion", "animated-base_release"})
public final class AnimatedDrawableBackendFrameRenderer
implements BitmapFrameRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BitmapFrameCache bitmapFrameCache;
    @NotNull
    private AnimatedDrawableBackend animatedDrawableBackend;
    private final boolean isNewRenderImplementation;
    @NotNull
    private AnimatedImageCompositor animatedImageCompositor;
    @NotNull
    private final AnimatedImageCompositor.Callback callback;
    @NotNull
    private static final Class<?> TAG = AnimatedDrawableBackendFrameRenderer.class;

    public AnimatedDrawableBackendFrameRenderer(@NotNull BitmapFrameCache bitmapFrameCache, @NotNull AnimatedDrawableBackend animatedDrawableBackend, boolean isNewRenderImplementation) {
        Intrinsics.checkNotNullParameter((Object)bitmapFrameCache, (String)"bitmapFrameCache");
        Intrinsics.checkNotNullParameter((Object)animatedDrawableBackend, (String)"animatedDrawableBackend");
        this.bitmapFrameCache = bitmapFrameCache;
        this.animatedDrawableBackend = animatedDrawableBackend;
        this.isNewRenderImplementation = isNewRenderImplementation;
        this.callback = new AnimatedImageCompositor.Callback(this){
            final /* synthetic */ AnimatedDrawableBackendFrameRenderer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onIntermediateResult(int frameNumber, Bitmap bitmap) {
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            }

            public CloseableReference<Bitmap> getCachedBitmap(int frameNumber) {
                return AnimatedDrawableBackendFrameRenderer.access$getBitmapFrameCache$p(this.this$0).getCachedFrame(frameNumber);
            }
        };
        this.animatedImageCompositor = new AnimatedImageCompositor(this.animatedDrawableBackend, this.isNewRenderImplementation, this.callback);
    }

    public void setBounds(@Nullable Rect bounds) {
        AnimatedDrawableBackend animatedDrawableBackend = this.animatedDrawableBackend.forNewBounds(bounds);
        Intrinsics.checkNotNullExpressionValue((Object)animatedDrawableBackend, (String)"forNewBounds(...)");
        AnimatedDrawableBackend newBackend = animatedDrawableBackend;
        if (newBackend != this.animatedDrawableBackend) {
            this.animatedDrawableBackend = newBackend;
            this.animatedImageCompositor = new AnimatedImageCompositor(this.animatedDrawableBackend, this.isNewRenderImplementation, this.callback);
        }
    }

    public int getIntrinsicWidth() {
        return this.animatedDrawableBackend.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.animatedDrawableBackend.getHeight();
    }

    public boolean renderFrame(int frameNumber, @NotNull Bitmap targetBitmap) {
        Intrinsics.checkNotNullParameter((Object)targetBitmap, (String)"targetBitmap");
        try {
            this.animatedImageCompositor.renderFrame(frameNumber, targetBitmap);
        }
        catch (IllegalStateException exception) {
            Object[] objectArray = new Object[]{frameNumber};
            FLog.e(TAG, (Throwable)exception, (String)"Rendering of frame unsuccessful. Frame number: %d", (Object[])objectArray);
            return false;
        }
        return true;
    }

    public static final /* synthetic */ BitmapFrameCache access$getBitmapFrameCache$p(AnimatedDrawableBackendFrameRenderer $this) {
        return $this.bitmapFrameCache;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/fresco/animation/bitmap/wrapper/AnimatedDrawableBackendFrameRenderer$Companion;", "", "<init>", "()V", "TAG", "Ljava/lang/Class;", "animated-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

