/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.util;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Build;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/facebook/imagepipeline/animated/util/AnimatedDrawableUtil;", "", "<init>", "()V", "fixFrameDurations", "", "frameDurationMs", "", "getTotalDurationFromFrameDurations", "", "getFrameTimeStampsFromDurations", "frameDurationsMs", "getFrameForTimestampMs", "frameTimestampsMs", "timestampMs", "getSizeOfBitmap", "bitmap", "Landroid/graphics/Bitmap;", "Companion", "animated-base_release"})
public final class AnimatedDrawableUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MIN_FRAME_DURATION_MS = 11;
    private static final int FRAME_DURATION_MS_FOR_MIN = 100;

    public final void fixFrameDurations(@NotNull int[] frameDurationMs) {
        Intrinsics.checkNotNullParameter((Object)frameDurationMs, (String)"frameDurationMs");
        int n = frameDurationMs.length;
        for (int i = 0; i < n; ++i) {
            if (frameDurationMs[i] >= 11) continue;
            frameDurationMs[i] = 100;
        }
    }

    public final int getTotalDurationFromFrameDurations(@NotNull int[] frameDurationMs) {
        Intrinsics.checkNotNullParameter((Object)frameDurationMs, (String)"frameDurationMs");
        int totalMs = 0;
        int n = frameDurationMs.length;
        for (int i = 0; i < n; ++i) {
            totalMs += frameDurationMs[i];
        }
        return totalMs;
    }

    @NotNull
    public final int[] getFrameTimeStampsFromDurations(@NotNull int[] frameDurationsMs) {
        Intrinsics.checkNotNullParameter((Object)frameDurationsMs, (String)"frameDurationsMs");
        int[] frameTimestampsMs = new int[frameDurationsMs.length];
        int accumulatedDurationMs = 0;
        int n = frameDurationsMs.length;
        for (int i = 0; i < n; ++i) {
            frameTimestampsMs[i] = accumulatedDurationMs;
            accumulatedDurationMs += frameDurationsMs[i];
        }
        return frameTimestampsMs;
    }

    public final int getFrameForTimestampMs(@Nullable int[] frameTimestampsMs, int timestampMs) {
        int index = Arrays.binarySearch(frameTimestampsMs, timestampMs);
        return index < 0 ? -index - 1 - 1 : index;
    }

    @SuppressLint(value={"NewApi"})
    public final int getSizeOfBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        return Build.VERSION.SDK_INT >= 19 ? bitmap.getAllocationByteCount() : bitmap.getByteCount();
    }

    @JvmStatic
    public static final boolean isOutsideRange(int startFrame, int endFrame, int frameNumber) {
        return Companion.isOutsideRange(startFrame, endFrame, frameNumber);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/imagepipeline/animated/util/AnimatedDrawableUtil$Companion;", "", "<init>", "()V", "MIN_FRAME_DURATION_MS", "", "FRAME_DURATION_MS_FOR_MIN", "isOutsideRange", "", "startFrame", "endFrame", "frameNumber", "animated-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isOutsideRange(int startFrame, int endFrame, int frameNumber) {
            if (startFrame == -1 || endFrame == -1) {
                return true;
            }
            boolean outsideRange = startFrame <= endFrame ? frameNumber < startFrame || frameNumber > endFrame : frameNumber < startFrame && frameNumber > endFrame;
            return outsideRange;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

