/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation.ondemandanimation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.backend.AnimationInformation;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.AnimationLoaderExecutor;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.FpsCompressorInfo;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.LoadFramePriorityTask;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.AnimationBitmapFrame;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.CircularList;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameLoader;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameResult;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 <2\u00020\u0001:\u0001<B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u000fH\u0016J*\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f2\b\b\u0002\u0010'\u001a\u00020\u000fH\u0003J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010$\u001a\u00020\u000fH\u0002J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0017J\b\u0010-\u001a\u00020\u000fH\u0002J\u0018\u0010.\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0002J6\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0002J\b\u00101\u001a\u00020\u001fH\u0016J&\u00102\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001f04H\u0017J\u001e\u00105\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0002J \u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u000fH\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u0011H\u0002J\f\u0010!\u001a\u00020\u000f*\u00020\tH\u0002J \u0010:\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010;\u001a\u00020\u0011H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/BufferFrameLoader;", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/FrameLoader;", "platformBitmapFactory", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "bitmapFrameRenderer", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;", "fpsCompressor", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo;", "animationInformation", "Lcom/facebook/fresco/animation/backend/AnimationInformation;", "(Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo;Lcom/facebook/fresco/animation/backend/AnimationInformation;)V", "getAnimationInformation", "()Lcom/facebook/fresco/animation/backend/AnimationInformation;", "bufferFramesHash", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "bufferFramesSequence", "", "bufferSize", "compressionFrameMap", "", "frameSequence", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/CircularList;", "isFetching", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastRenderedFrameNumber", "renderableFrameIndexes", "", "clear", "", "compressToFps", "fps", "extractDemandedFrame", "", "targetFrame", "width", "height", "count", "findNearestFrame", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/AnimationBitmapFrame;", "getFrame", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/FrameResult;", "frameNumber", "getThreshold", "loadNextFrameIfNeeded", "obtainFrame", "oldBitmapRef", "onStop", "prepareFrames", "onAnimationLoaded", "Lkotlin/Function0;", "renderFirstBitmap", "updateBitmap", "fromBitmap", "from", "dest", "set", "src", "Companion", "animated-drawable_release"})
@SourceDebugExtension(value={"SMAP\nBufferFrameLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferFrameLoader.kt\ncom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/BufferFrameLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1855#2,2:274\n1855#2,2:276\n766#2:278\n857#2,2:279\n1855#2:281\n1856#2:283\n1855#2,2:284\n1855#2,2:286\n1#3:282\n*S KotlinDebug\n*F\n+ 1 BufferFrameLoader.kt\ncom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/BufferFrameLoader\n*L\n118#1:274,2\n126#1:276,2\n158#1:278\n158#1:279,2\n165#1:281\n165#1:283\n236#1:284,2\n238#1:286,2\n*E\n"})
public final class BufferFrameLoader
implements FrameLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlatformBitmapFactory platformBitmapFactory;
    @NotNull
    private final BitmapFrameRenderer bitmapFrameRenderer;
    @NotNull
    private final FpsCompressorInfo fpsCompressor;
    @NotNull
    private final AnimationInformation animationInformation;
    private final int bufferSize;
    @NotNull
    private final ConcurrentHashMap<Integer, CloseableReference<Bitmap>> bufferFramesHash;
    @NotNull
    private List<Integer> bufferFramesSequence;
    @NotNull
    private final AtomicBoolean isFetching;
    @NotNull
    private final CircularList frameSequence;
    private int lastRenderedFrameNumber;
    @NotNull
    private Map<Integer, Integer> compressionFrameMap;
    @NotNull
    private Set<Integer> renderableFrameIndexes;
    private static final float THRESHOLD_PERCENTAGE = 0.5f;
    private static final int BUFFER_SECOND_SIZE = 1;

    public BufferFrameLoader(@NotNull PlatformBitmapFactory platformBitmapFactory, @NotNull BitmapFrameRenderer bitmapFrameRenderer, @NotNull FpsCompressorInfo fpsCompressor, @NotNull AnimationInformation animationInformation) {
        Intrinsics.checkNotNullParameter((Object)platformBitmapFactory, (String)"platformBitmapFactory");
        Intrinsics.checkNotNullParameter((Object)bitmapFrameRenderer, (String)"bitmapFrameRenderer");
        Intrinsics.checkNotNullParameter((Object)fpsCompressor, (String)"fpsCompressor");
        Intrinsics.checkNotNullParameter((Object)animationInformation, (String)"animationInformation");
        this.platformBitmapFactory = platformBitmapFactory;
        this.bitmapFrameRenderer = bitmapFrameRenderer;
        this.fpsCompressor = fpsCompressor;
        this.animationInformation = animationInformation;
        this.bufferSize = this.fps(this.getAnimationInformation()) * 1;
        this.bufferFramesHash = new ConcurrentHashMap();
        this.bufferFramesSequence = CollectionsKt.emptyList();
        this.isFetching = new AtomicBoolean(false);
        this.frameSequence = new CircularList(this.getAnimationInformation().getFrameCount());
        this.lastRenderedFrameNumber = -1;
        this.compressionFrameMap = MapsKt.emptyMap();
        this.renderableFrameIndexes = SetsKt.emptySet();
        this.compressToFps(this.fps(this.getAnimationInformation()));
    }

    @Override
    @NotNull
    public AnimationInformation getAnimationInformation() {
        return this.animationInformation;
    }

    @Override
    @UiThread
    @NotNull
    public FrameResult getFrame(int frameNumber, int width, int height) {
        CloseableReference cachedFrame;
        int cachedFrameIndex;
        Integer n = this.compressionFrameMap.get(frameNumber);
        if (n == null) {
            AnimationBitmapFrame animationBitmapFrame = this.findNearestFrame(frameNumber);
            CloseableReference<Bitmap> it = animationBitmapFrame != null ? animationBitmapFrame.getBitmap() : null;
            boolean bl = false;
            CloseableReference<Bitmap> closeableReference = it;
            CloseableReference bitmapRef = closeableReference != null ? closeableReference.cloneOrNull() : null;
            this.lastRenderedFrameNumber = frameNumber;
            return new FrameResult((CloseableReference<Bitmap>)bitmapRef, bitmapRef == null ? FrameResult.FrameType.MISSING : FrameResult.FrameType.NEAREST);
        }
        this.lastRenderedFrameNumber = cachedFrameIndex = n.intValue();
        CloseableReference<Bitmap> closeableReference = this.bufferFramesHash.get(cachedFrameIndex);
        Object object = cachedFrame = closeableReference != null ? closeableReference.cloneOrNull() : null;
        if (cachedFrame != null) {
            if (this.frameSequence.isTargetAhead(this.getThreshold(), cachedFrameIndex, this.bufferSize)) {
                this.loadNextFrameIfNeeded(width, height);
            }
            return new FrameResult((CloseableReference<Bitmap>)cachedFrame, FrameResult.FrameType.SUCCESS);
        }
        this.loadNextFrameIfNeeded(width, height);
        AnimationBitmapFrame animationBitmapFrame = this.findNearestFrame(cachedFrameIndex);
        CloseableReference<Bitmap> it = animationBitmapFrame != null ? animationBitmapFrame.getBitmap() : null;
        boolean bl = false;
        CloseableReference<Bitmap> closeableReference2 = it;
        CloseableReference bitmapRef = closeableReference2 != null ? closeableReference2.cloneOrNull() : null;
        return new FrameResult((CloseableReference<Bitmap>)bitmapRef, bitmapRef == null ? FrameResult.FrameType.MISSING : FrameResult.FrameType.NEAREST);
    }

    private final int getThreshold() {
        int n;
        if (this.bufferFramesSequence.isEmpty()) {
            n = (int)((float)this.bufferSize * 0.5f);
        } else {
            int middlePoint = (int)((float)this.bufferFramesSequence.size() * 0.5f);
            n = ((Number)this.bufferFramesSequence.get(middlePoint)).intValue();
        }
        return n;
    }

    @Override
    @UiThread
    public void prepareFrames(int width, int height, @NotNull Function0<Unit> onAnimationLoaded) {
        Intrinsics.checkNotNullParameter(onAnimationLoaded, (String)"onAnimationLoaded");
        this.loadNextFrameIfNeeded(width, height);
        onAnimationLoaded.invoke();
    }

    @Override
    public void compressToFps(int fps) {
        int durationMs = this.getAnimationInformation().getLoopDurationMs() * RangesKt.coerceAtLeast((int)this.getAnimationInformation().getLoopCount(), (int)1);
        this.compressionFrameMap = this.fpsCompressor.calculateReducedIndexes(durationMs, this.getAnimationInformation().getFrameCount(), RangesKt.coerceAtMost((int)fps, (int)this.fps(this.getAnimationInformation())));
        this.renderableFrameIndexes = CollectionsKt.toSet((Iterable)this.compressionFrameMap.values());
    }

    @Override
    public void onStop() {
        AnimationBitmapFrame nearestFrame2 = this.findNearestFrame(this.lastRenderedFrameNumber);
        Set set = this.bufferFramesHash.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"bufferFramesHash.keys");
        AnimationBitmapFrame animationBitmapFrame = nearestFrame2;
        List indexesToClose = CollectionsKt.filterNotNull((Iterable)SetsKt.minus((Set)set, (Object)(animationBitmapFrame != null ? Integer.valueOf(animationBitmapFrame.getFrameNumber()) : null)));
        Iterable $this$forEach$iv = indexesToClose;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Integer frameNumber = (Integer)element$iv;
            boolean bl = false;
            CloseableReference.closeSafely(this.bufferFramesHash.get(frameNumber));
            this.bufferFramesHash.remove(frameNumber);
        }
    }

    @Override
    public void clear() {
        Collection<CloseableReference<Bitmap>> collection = this.bufferFramesHash.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"bufferFramesHash.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloseableReference it = (CloseableReference)element$iv;
            boolean bl = false;
            CloseableReference.closeSafely((CloseableReference)it);
        }
        this.bufferFramesHash.clear();
        this.lastRenderedFrameNumber = -1;
    }

    private final void loadNextFrameIfNeeded(int width, int height) {
        if (this.isFetching.getAndSet(true)) {
            return;
        }
        AnimationLoaderExecutor.INSTANCE.execute(new LoadFramePriorityTask(this, width, height){
            @NotNull
            private final LoadFramePriorityTask.Priority priority;
            final /* synthetic */ BufferFrameLoader this$0;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            {
                this.this$0 = $receiver;
                this.$width = $width;
                this.$height = $height;
                this.priority = LoadFramePriorityTask.Priority.HIGH;
            }

            @NotNull
            public LoadFramePriorityTask.Priority getPriority() {
                return this.priority;
            }

            public void run() {
                int targetFrame;
                boolean success;
                while (!(success = BufferFrameLoader.extractDemandedFrame$default(this.this$0, targetFrame = RangesKt.coerceAtLeast((int)BufferFrameLoader.access$getLastRenderedFrameNumber$p(this.this$0), (int)0), this.$width, this.$height, 0, 8, null))) {
                }
                BufferFrameLoader.access$isFetching$p(this.this$0).set(false);
            }

            public int compareTo(@NotNull LoadFramePriorityTask other) {
                return LoadFramePriorityTask.DefaultImpls.compareTo(this, other);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final boolean extractDemandedFrame(int targetFrame, int width, int height, int count) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.frameSequence.sublist(targetFrame, this.bufferSize);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!this.renderableFrameIndexes.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nextWindow = (List)destination$iv$iv;
        Set nextWindowIndexes = CollectionsKt.toSet((Iterable)nextWindow);
        Set set = this.bufferFramesHash.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"bufferFramesHash.keys");
        ArrayDeque oldFramesNumbers = new ArrayDeque(SetsKt.minus((Set)set, (Iterable)nextWindowIndexes));
        Iterable $this$forEach$iv = nextWindow;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int newFrameNumber = ((Number)element$iv).intValue();
            boolean bl = false;
            if (this.bufferFramesHash.get(newFrameNumber) != null) continue;
            if (this.lastRenderedFrameNumber != -1 && !nextWindowIndexes.contains(this.lastRenderedFrameNumber)) {
                return false;
            }
            Integer deprecatedFrameNumber = (Integer)oldFramesNumbers.pollFirst();
            CloseableReference<Bitmap> deprecatedFrameBitmap = deprecatedFrameNumber != null ? this.bufferFramesHash.get(deprecatedFrameNumber) : null;
            CloseableReference<Bitmap> newFrame = deprecatedFrameBitmap == null ? this.obtainFrame(null, newFrameNumber, width, height) : this.obtainFrame(deprecatedFrameBitmap, newFrameNumber, width, height);
            CloseableReference.closeSafely(deprecatedFrameBitmap);
            Integer n = deprecatedFrameNumber;
            if (n != null) {
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"deprecatedFrameNumber");
                int it = ((Number)deprecatedFrameNumber).intValue();
                boolean bl2 = false;
                this.bufferFramesHash.remove(it);
            }
            Integer n2 = newFrameNumber;
            ((Map)this.bufferFramesHash).put(n2, newFrame);
        }
        this.bufferFramesSequence = nextWindow;
        return true;
    }

    static /* synthetic */ boolean extractDemandedFrame$default(BufferFrameLoader bufferFrameLoader, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return bufferFrameLoader.extractDemandedFrame(n, n2, n3, n4);
    }

    private final CloseableReference<Bitmap> obtainFrame(CloseableReference<Bitmap> oldBitmapRef, int targetFrame, int width, int height) {
        block2: {
            CloseableReference<Bitmap> closeableReference;
            CloseableReference nearestBitmap;
            CloseableReference<Bitmap> nearestFrame2;
            block4: {
                block3: {
                    nearestFrame2 = this.findNearestFrame(targetFrame);
                    CloseableReference<Bitmap> closeableReference2 = nearestFrame2;
                    CloseableReference closeableReference3 = closeableReference2 != null && (closeableReference2 = closeableReference2.getBitmap()) != null ? closeableReference2.cloneOrNull() : (nearestBitmap = null);
                    if (nearestFrame2 == null || nearestBitmap == null) break block2;
                    CloseableReference<Bitmap> closeableReference4 = oldBitmapRef;
                    Object copyOldBitmap = closeableReference4 != null ? closeableReference4.cloneOrNull() : null;
                    closeableReference = copyOldBitmap;
                    if (closeableReference == null) break block3;
                    Object object = nearestBitmap.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nearestBitmap.get()");
                    if ((closeableReference = this.set(closeableReference, (Bitmap)object)) != null) break block4;
                }
                CloseableReference closeableReference5 = this.platformBitmapFactory.createBitmap((Bitmap)nearestBitmap.get());
                closeableReference = closeableReference5;
                Intrinsics.checkNotNullExpressionValue((Object)closeableReference5, (String)"platformBitmapFactory.cr\u2026tmap(nearestBitmap.get())");
            }
            CloseableReference<Bitmap> copyBitmap = closeableReference;
            CloseableReference.closeSafely((CloseableReference)nearestBitmap);
            Object object = copyBitmap.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"copyBitmap.get()");
            this.updateBitmap((Bitmap)object, nearestFrame2.getFrameNumber(), targetFrame);
            return copyBitmap;
        }
        CloseableReference<Bitmap> bitmap = this.renderFirstBitmap(width, height);
        Object object = bitmap.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bitmap.get()");
        this.updateBitmap((Bitmap)object, 0, targetFrame);
        return bitmap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AnimationBitmapFrame findNearestFrame(int targetFrame) {
        AnimationBitmapFrame animationBitmapFrame;
        AnimationBitmapFrame animationBitmapFrame2;
        Iterator iterator = ((Iterable)new IntRange(0, this.frameSequence.getSize())).iterator();
        do {
            if (!iterator.hasNext()) return null;
            int position = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int closestFrame = this.frameSequence.getPosition(targetFrame - position);
            CloseableReference<Bitmap> closeableReference = this.bufferFramesHash.get(closestFrame);
            if (closeableReference != null) {
                CloseableReference<Bitmap> closeableReference2;
                CloseableReference<Bitmap> closeableReference3;
                CloseableReference<Bitmap> it = closeableReference3 = closeableReference;
                boolean bl2 = false;
                Object object = closeableReference2 = it.isValid() ? closeableReference3 : null;
                if (closeableReference2 != null) {
                    it = closeableReference2;
                    boolean bl3 = false;
                    animationBitmapFrame = new AnimationBitmapFrame(closestFrame, it);
                    continue;
                }
            }
            animationBitmapFrame = null;
        } while ((animationBitmapFrame2 = animationBitmapFrame) == null);
        AnimationBitmapFrame animationBitmapFrame3 = animationBitmapFrame2;
        return animationBitmapFrame3;
    }

    private final CloseableReference<Bitmap> renderFirstBitmap(int width, int height) {
        CloseableReference closeableReference = this.platformBitmapFactory.createBitmap(width, height);
        Intrinsics.checkNotNullExpressionValue((Object)closeableReference, (String)"platformBitmapFactory.createBitmap(width, height)");
        CloseableReference base = closeableReference;
        Object object = base.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"base.get()");
        this.bitmapFrameRenderer.renderFrame(0, (Bitmap)object);
        return base;
    }

    private final void updateBitmap(Bitmap fromBitmap, int from, int dest) {
        block3: {
            block2: {
                if (from <= dest) break block2;
                this.clear(fromBitmap);
                Iterable $this$forEach$iv = (Iterable)new IntRange(0, dest);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    this.bitmapFrameRenderer.renderFrame(it, fromBitmap);
                }
                break block3;
            }
            if (from >= dest) break block3;
            Iterable $this$forEach$iv = (Iterable)new IntRange(from + 1, dest);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                this.bitmapFrameRenderer.renderFrame(it, fromBitmap);
            }
        }
    }

    private final void clear(Bitmap $this$clear) {
        new Canvas($this$clear).drawColor(0, PorterDuff.Mode.CLEAR);
    }

    private final CloseableReference<Bitmap> set(CloseableReference<Bitmap> $this$set, Bitmap src) {
        if ($this$set.isValid()) {
            Canvas canvas = new Canvas((Bitmap)$this$set.get());
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
        }
        return $this$set;
    }

    private final int fps(AnimationInformation $this$fps) {
        return (int)RangesKt.coerceAtLeast((long)(TimeUnit.SECONDS.toMillis(1L) / (long)($this$fps.getLoopDurationMs() / $this$fps.getFrameCount())), (long)1L);
    }

    public static final /* synthetic */ int access$getLastRenderedFrameNumber$p(BufferFrameLoader $this) {
        return $this.lastRenderedFrameNumber;
    }

    public static final /* synthetic */ AtomicBoolean access$isFetching$p(BufferFrameLoader $this) {
        return $this.isFetching;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/BufferFrameLoader$Companion;", "", "()V", "BUFFER_SECOND_SIZE", "", "THRESHOLD_PERCENTAGE", "", "animated-drawable_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

