/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation.loadframe;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u00062\u0006\u0010\t\u001a\u00020\u0003J6\u0010\u000f\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u00062\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0002J\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo;", "", "maxFpsLimit", "", "(I)V", "calculateReducedIndexes", "", "durationMs", "frameCount", "targetFps", "compress", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo$CompressionResult;", "frameBitmaps", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "compressAnimation", "realToReducedIndex", "millisecondsToSeconds", "", "CompressionResult", "animated-drawable_release"})
@SourceDebugExtension(value={"SMAP\nFpsCompressorInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FpsCompressorInfo.kt\ncom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,113:1\n1271#2,2:114\n1285#2,4:116\n215#3,2:120\n*S KotlinDebug\n*F\n+ 1 FpsCompressorInfo.kt\ncom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo\n*L\n44#1:114,2\n44#1:116,4\n67#1:120,2\n*E\n"})
public final class FpsCompressorInfo {
    private final int maxFpsLimit;

    public FpsCompressorInfo(int maxFpsLimit) {
        this.maxFpsLimit = maxFpsLimit;
    }

    @NotNull
    public final CompressionResult compress(int durationMs, @NotNull Map<Integer, ? extends CloseableReference<Bitmap>> frameBitmaps, int targetFps) {
        Intrinsics.checkNotNullParameter(frameBitmaps, (String)"frameBitmaps");
        Map<Integer, Integer> realToCompressIndex = this.calculateReducedIndexes(durationMs, frameBitmaps.size(), targetFps);
        return this.compressAnimation(frameBitmaps, realToCompressIndex);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Integer, Integer> calculateReducedIndexes(int durationMs, int frameCount, int targetFps) {
        int sanitiseFps = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)targetFps, (int)1), (int)this.maxFpsLimit);
        float maxAllowedFrames = RangesKt.coerceAtLeast((float)((float)sanitiseFps * this.millisecondsToSeconds(durationMs)), (float)0.0f);
        float skipRatio = (float)frameCount / RangesKt.coerceAtMost((float)maxAllowedFrames, (float)frameCount);
        int prevFrame = 0;
        Iterable $this$associateWith$iv = (Iterable)RangesKt.until((int)0, (int)frameCount);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            int n = ((Number)element$iv$iv).intValue();
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            if ((int)((float)it % skipRatio) == 0) {
                prevFrame = it;
            }
            Integer n2 = prevFrame;
            map.put(t, n2);
        }
        return result$iv;
    }

    private final CompressionResult compressAnimation(Map<Integer, ? extends CloseableReference<Bitmap>> frameBitmaps, Map<Integer, Integer> realToReducedIndex) {
        Map compressedAnim = new LinkedHashMap();
        List removedFrames = new ArrayList();
        Map<Integer, ? extends CloseableReference<Bitmap>> $this$forEach$iv = frameBitmaps;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, ? extends CloseableReference<Bitmap>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ? extends CloseableReference<Bitmap>> element$iv;
            Map.Entry<Integer, ? extends CloseableReference<Bitmap>> entry = element$iv = iterator.next();
            boolean bl = false;
            int i = ((Number)entry.getKey()).intValue();
            CloseableReference<Bitmap> bitmapRef = entry.getValue();
            Integer n = realToReducedIndex.get(i);
            if (n == null) {
                continue;
            }
            int reducedIndex = n;
            if (compressedAnim.containsKey(reducedIndex)) {
                removedFrames.add(bitmapRef);
                continue;
            }
            Integer n2 = reducedIndex;
            compressedAnim.put(n2, bitmapRef);
        }
        return new CompressionResult(compressedAnim, realToReducedIndex, removedFrames);
    }

    public final float millisecondsToSeconds(int $this$millisecondsToSeconds) {
        return (float)$this$millisecondsToSeconds / 1000.0f;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001BG\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\t\u00a2\u0006\u0002\u0010\nR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo$CompressionResult;", "", "compressedAnim", "", "", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "realToReducedIndex", "removedFrames", "", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/List;)V", "getCompressedAnim", "()Ljava/util/Map;", "getRealToReducedIndex", "getRemovedFrames", "()Ljava/util/List;", "animated-drawable_release"})
    public static final class CompressionResult {
        @NotNull
        private final Map<Integer, CloseableReference<Bitmap>> compressedAnim;
        @NotNull
        private final Map<Integer, Integer> realToReducedIndex;
        @NotNull
        private final List<CloseableReference<Bitmap>> removedFrames;

        public CompressionResult(@NotNull Map<Integer, ? extends CloseableReference<Bitmap>> compressedAnim, @NotNull Map<Integer, Integer> realToReducedIndex, @NotNull List<? extends CloseableReference<Bitmap>> removedFrames) {
            Intrinsics.checkNotNullParameter(compressedAnim, (String)"compressedAnim");
            Intrinsics.checkNotNullParameter(realToReducedIndex, (String)"realToReducedIndex");
            Intrinsics.checkNotNullParameter(removedFrames, (String)"removedFrames");
            this.compressedAnim = compressedAnim;
            this.realToReducedIndex = realToReducedIndex;
            this.removedFrames = removedFrames;
        }

        @NotNull
        public final Map<Integer, CloseableReference<Bitmap>> getCompressedAnim() {
            return this.compressedAnim;
        }

        @NotNull
        public final Map<Integer, Integer> getRealToReducedIndex() {
            return this.realToReducedIndex;
        }

        @NotNull
        public final List<CloseableReference<Bitmap>> getRemovedFrames() {
            return this.removedFrames;
        }
    }
}

