/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation.ondemandanimation;

import android.os.Handler;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.AnimationCoordinator;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.DynamicRenderingFps;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameLoaderFactory;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameResult;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/AnimationCoordinator;", "", "()V", "FPS_STEP_PERCENTAGE", "", "FREQUENCY_LOADERS_MS", "", "FREQUENCY_PERFORMANCE_MS", "MIN_RENDERING_FPS_PERCENTAGE", "calculatePerformance", "Ljava/lang/Runnable;", "clearUnusedFrameLoaders", "criticalCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "failuresCounter", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "handler$delegate", "Lkotlin/Lazy;", "runningAnimations", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/DynamicRenderingFps;", "", "successCounter", "onRenderFrame", "", "animation", "frameResult", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/FrameResult;", "scheduleLoaders", "", "schedulePerformance", "updateRenderingFps", "delta", "animated-drawable_release"})
@SourceDebugExtension(value={"SMAP\nAnimationCoordinator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationCoordinator.kt\ncom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/AnimationCoordinator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,130:1\n215#2,2:131\n215#2,2:133\n*S KotlinDebug\n*F\n+ 1 AnimationCoordinator.kt\ncom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/AnimationCoordinator\n*L\n53#1:131,2\n58#1:133,2\n*E\n"})
public final class AnimationCoordinator {
    @NotNull
    public static final AnimationCoordinator INSTANCE = new AnimationCoordinator();
    private static final long FREQUENCY_PERFORMANCE_MS = 2000L;
    private static final long FREQUENCY_LOADERS_MS = 10000L;
    private static final float FPS_STEP_PERCENTAGE = 0.2f;
    private static final float MIN_RENDERING_FPS_PERCENTAGE = 0.5f;
    @NotNull
    private static final AtomicInteger successCounter = new AtomicInteger(0);
    @NotNull
    private static final AtomicInteger failuresCounter = new AtomicInteger(0);
    @NotNull
    private static final AtomicInteger criticalCounter = new AtomicInteger(0);
    @NotNull
    private static final ConcurrentHashMap<DynamicRenderingFps, Integer> runningAnimations = new ConcurrentHashMap();
    @NotNull
    private static final Lazy handler$delegate = LazyKt.lazy((Function0)handler.2.INSTANCE);
    @NotNull
    private static final Runnable calculatePerformance = AnimationCoordinator::calculatePerformance$lambda$2;
    @NotNull
    private static final Runnable clearUnusedFrameLoaders = AnimationCoordinator::clearUnusedFrameLoaders$lambda$3;

    private AnimationCoordinator() {
    }

    private final Handler getHandler() {
        Lazy lazy = handler$delegate;
        return (Handler)lazy.getValue();
    }

    private final boolean schedulePerformance() {
        return this.getHandler().postDelayed(calculatePerformance, 2000L);
    }

    private final boolean scheduleLoaders() {
        return this.getHandler().postDelayed(clearUnusedFrameLoaders, 10000L);
    }

    private final void updateRenderingFps(DynamicRenderingFps animation, int delta) {
        int minRenderingFps = (int)RangesKt.coerceAtLeast((float)((float)animation.getAnimationFps() * 0.5f), (float)1.0f);
        int renderingFps = RangesKt.coerceIn((int)(animation.getRenderingFps() + delta), (int)minRenderingFps, (int)animation.getAnimationFps());
        if (renderingFps != animation.getRenderingFps()) {
            animation.setRenderingFps(renderingFps);
        }
    }

    public final void onRenderFrame(@NotNull DynamicRenderingFps animation, @NotNull FrameResult frameResult) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)frameResult, (String)"frameResult");
        if (!runningAnimations.contains(animation)) {
            int fps = animation.getAnimationFps();
            int fpsStep = (int)((float)fps * 0.2f);
            Integer n = fpsStep;
            ((Map)runningAnimations).put(animation, n);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[frameResult.getType().ordinal()]) {
            case 1: {
                successCounter.incrementAndGet();
                break;
            }
            case 2: {
                failuresCounter.incrementAndGet();
                break;
            }
            case 3: {
                criticalCounter.incrementAndGet();
            }
        }
    }

    private static final void calculatePerformance$lambda$2() {
        float critical;
        float failures;
        float success = successCounter.getAndSet(0);
        float totalFrames = success + (failures = (float)failuresCounter.getAndSet(0)) + (critical = (float)criticalCounter.getAndSet(0));
        if (totalFrames > 0.0f) {
            float successRatio = success / totalFrames;
            float failuresRatio = failures / totalFrames;
            float criticalRatio = critical / totalFrames;
            if (failuresRatio > 0.25f || criticalRatio > 0.1f) {
                Map $this$forEach$iv = runningAnimations;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    DynamicRenderingFps animation = (DynamicRenderingFps)entry.getKey();
                    int fpsStep = ((Number)entry.getValue()).intValue();
                    INSTANCE.updateRenderingFps(animation, -fpsStep);
                }
            } else if (successRatio > 0.98f) {
                Map $this$forEach$iv = runningAnimations;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    DynamicRenderingFps animation = (DynamicRenderingFps)entry.getKey();
                    int fpsStep = ((Number)entry.getValue()).intValue();
                    INSTANCE.updateRenderingFps(animation, fpsStep);
                }
            }
            runningAnimations.clear();
        }
        INSTANCE.schedulePerformance();
    }

    private static final void clearUnusedFrameLoaders$lambda$3() {
        long maxUnusedTime = System.currentTimeMillis() - 10000L;
        FrameLoaderFactory.Companion.clearUnusedUntil(new Date(maxUnusedTime));
        INSTANCE.scheduleLoaders();
    }

    static {
        INSTANCE.getHandler().post(calculatePerformance);
        INSTANCE.getHandler().post(clearUnusedFrameLoaders);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FrameResult.FrameType.values().length];
            try {
                nArray[FrameResult.FrameType.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FrameResult.FrameType.NEAREST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FrameResult.FrameType.MISSING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

