/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation.ondemandanimation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.backend.AnimationInformation;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.AnimationLoaderExecutor;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.FpsCompressorInfo;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.AnimationBitmapFrame;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.CircularList;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameLoader;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameResult;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 62\u00020\u0001:\u000256B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J*\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\b\b\u0002\u0010$\u001a\u00020\u000fH\u0003J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\u000fH\u0003J \u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000fH\u0017J\u0018\u0010+\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000fH\u0002J.\u0010,\u001a\u00020\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000fH\u0002J&\u00100\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001d02H\u0017J\u0012\u0010\u001c\u001a\u00020\u001d*\b\u0012\u0004\u0012\u00020/0.H\u0002J\f\u0010\u001f\u001a\u00020\u000f*\u00020\tH\u0002J \u00103\u001a\b\u0012\u0004\u0012\u00020/0.*\b\u0012\u0004\u0012\u00020/0.2\u0006\u00104\u001a\u00020/H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/BufferFrameLoader;", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/FrameLoader;", "platformBitmapFactory", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "bitmapFrameRenderer", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;", "fpsCompressor", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo;", "animationInformation", "Lcom/facebook/fresco/animation/backend/AnimationInformation;", "(Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo;Lcom/facebook/fresco/animation/backend/AnimationInformation;)V", "getAnimationInformation", "()Lcom/facebook/fresco/animation/backend/AnimationInformation;", "bufferFramesHash", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/BufferFrameLoader$BufferFrame;", "bufferSize", "compressionFrameMap", "", "frameSequence", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/CircularList;", "isFetching", "", "lastRenderedFrameNumber", "renderableFrameIndexes", "", "thresholdFrame", "clear", "", "compressToFps", "fps", "extractDemandedFrame", "targetFrame", "width", "height", "count", "findNearestFrame", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/AnimationBitmapFrame;", "findNearestToRender", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/FrameResult;", "getFrame", "frameNumber", "loadNextFrames", "obtainFrame", "targetBitmap", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "prepareFrames", "onAnimationLoaded", "Lkotlin/Function0;", "set", "src", "BufferFrame", "Companion", "animated-drawable_release"})
@SourceDebugExtension(value={"SMAP\nBufferFrameLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferFrameLoader.kt\ncom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/BufferFrameLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n1#2:257\n1855#3,2:258\n766#3:260\n857#3,2:261\n1855#3,2:263\n1855#3,2:265\n1855#3,2:267\n*S KotlinDebug\n*F\n+ 1 BufferFrameLoader.kt\ncom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/BufferFrameLoader\n*L\n107#1:258,2\n135#1:260\n135#1:261,2\n142#1:263,2\n196#1:265,2\n202#1:267,2\n*E\n"})
public final class BufferFrameLoader
implements FrameLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlatformBitmapFactory platformBitmapFactory;
    @NotNull
    private final BitmapFrameRenderer bitmapFrameRenderer;
    @NotNull
    private final FpsCompressorInfo fpsCompressor;
    @NotNull
    private final AnimationInformation animationInformation;
    private final int bufferSize;
    @NotNull
    private final ConcurrentHashMap<Integer, BufferFrame> bufferFramesHash;
    private volatile int thresholdFrame;
    private volatile boolean isFetching;
    @NotNull
    private final CircularList frameSequence;
    private int lastRenderedFrameNumber;
    @NotNull
    private Map<Integer, Integer> compressionFrameMap;
    @NotNull
    private Set<Integer> renderableFrameIndexes;
    private static final float THRESHOLD_PERCENTAGE = 0.5f;
    private static final int BUFFER_SECOND_SIZE = 1;

    public BufferFrameLoader(@NotNull PlatformBitmapFactory platformBitmapFactory, @NotNull BitmapFrameRenderer bitmapFrameRenderer, @NotNull FpsCompressorInfo fpsCompressor, @NotNull AnimationInformation animationInformation) {
        Intrinsics.checkNotNullParameter((Object)platformBitmapFactory, (String)"platformBitmapFactory");
        Intrinsics.checkNotNullParameter((Object)bitmapFrameRenderer, (String)"bitmapFrameRenderer");
        Intrinsics.checkNotNullParameter((Object)fpsCompressor, (String)"fpsCompressor");
        Intrinsics.checkNotNullParameter((Object)animationInformation, (String)"animationInformation");
        this.platformBitmapFactory = platformBitmapFactory;
        this.bitmapFrameRenderer = bitmapFrameRenderer;
        this.fpsCompressor = fpsCompressor;
        this.animationInformation = animationInformation;
        this.bufferSize = this.fps(this.getAnimationInformation()) * 1;
        this.bufferFramesHash = new ConcurrentHashMap();
        this.frameSequence = new CircularList(this.getAnimationInformation().getFrameCount());
        this.lastRenderedFrameNumber = -1;
        this.compressionFrameMap = MapsKt.emptyMap();
        this.renderableFrameIndexes = SetsKt.emptySet();
        this.compressToFps(this.fps(this.getAnimationInformation()));
        this.thresholdFrame = (int)((float)this.bufferSize * 0.5f);
    }

    @Override
    @NotNull
    public AnimationInformation getAnimationInformation() {
        return this.animationInformation;
    }

    @Override
    @UiThread
    @NotNull
    public FrameResult getFrame(int frameNumber, int width, int height) {
        BufferFrame cachedFrame;
        BufferFrame bufferFrame;
        int cachedFrameIndex;
        Integer n = this.compressionFrameMap.get(frameNumber);
        if (n == null) {
            return this.findNearestToRender(frameNumber);
        }
        this.lastRenderedFrameNumber = cachedFrameIndex = n.intValue();
        BufferFrame bufferFrame2 = this.bufferFramesHash.get(cachedFrameIndex);
        if (bufferFrame2 != null) {
            BufferFrame bufferFrame3;
            BufferFrame it = bufferFrame3 = bufferFrame2;
            boolean bl = false;
            bufferFrame = it.isFrameAvailable() ? bufferFrame3 : null;
        } else {
            bufferFrame = cachedFrame = null;
        }
        if (cachedFrame != null) {
            boolean isTargetAhead = this.frameSequence.isTargetAhead(this.thresholdFrame, cachedFrameIndex, this.bufferSize);
            if (isTargetAhead) {
                this.loadNextFrames(width, height);
            }
            return new FrameResult((CloseableReference<Bitmap>)cachedFrame.getBitmapRef().clone(), FrameResult.FrameType.SUCCESS);
        }
        this.loadNextFrames(width, height);
        return this.findNearestToRender(cachedFrameIndex);
    }

    @UiThread
    private final FrameResult findNearestToRender(int targetFrame) {
        FrameResult frameResult;
        AnimationBitmapFrame nearestFrame = this.findNearestFrame(targetFrame);
        if (nearestFrame != null) {
            CloseableReference closeableReference = nearestFrame.getBitmap().clone();
            Intrinsics.checkNotNullExpressionValue((Object)closeableReference, (String)"nearestFrame.bitmap.clone()");
            CloseableReference bitmapRef = closeableReference;
            this.lastRenderedFrameNumber = nearestFrame.getFrameNumber();
            frameResult = new FrameResult((CloseableReference<Bitmap>)bitmapRef, FrameResult.FrameType.NEAREST);
        } else {
            frameResult = new FrameResult(null, FrameResult.FrameType.MISSING);
        }
        return frameResult;
    }

    @Override
    @UiThread
    public void prepareFrames(int width, int height, @NotNull Function0<Unit> onAnimationLoaded) {
        Intrinsics.checkNotNullParameter(onAnimationLoaded, (String)"onAnimationLoaded");
        this.loadNextFrames(width, height);
        onAnimationLoaded.invoke();
    }

    @Override
    public void compressToFps(int fps) {
        int durationMs = this.getAnimationInformation().getLoopDurationMs() * RangesKt.coerceAtLeast((int)this.getAnimationInformation().getLoopCount(), (int)1);
        this.compressionFrameMap = this.fpsCompressor.calculateReducedIndexes(durationMs, this.getAnimationInformation().getFrameCount(), RangesKt.coerceAtMost((int)fps, (int)this.fps(this.getAnimationInformation())));
        this.renderableFrameIndexes = CollectionsKt.toSet((Iterable)this.compressionFrameMap.values());
    }

    @Override
    public void clear() {
        Collection<BufferFrame> collection = this.bufferFramesHash.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"bufferFramesHash.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BufferFrame it = (BufferFrame)element$iv;
            boolean bl = false;
            it.release();
        }
        this.bufferFramesHash.clear();
        this.lastRenderedFrameNumber = -1;
    }

    private final void loadNextFrames(int width, int height) {
        if (this.isFetching) {
            return;
        }
        this.isFetching = true;
        AnimationLoaderExecutor.INSTANCE.execute(() -> BufferFrameLoader.loadNextFrames$lambda$2(this, width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WorkerThread
    private final boolean extractDemandedFrame(int targetFrame, int width, int height, int count) {
        int n;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.frameSequence.sublist(targetFrame, this.bufferSize);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!this.renderableFrameIndexes.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nextWindow = (List)destination$iv$iv;
        Set nextWindowIndexes = CollectionsKt.toSet((Iterable)nextWindow);
        Set set = this.bufferFramesHash.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"bufferFramesHash.keys");
        ArrayDeque oldFramesNumbers = new ArrayDeque(SetsKt.minus((Set)set, (Iterable)nextWindowIndexes));
        Iterable $this$forEach$iv = nextWindow;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloseableReference ref;
            int newFrameNumber = ((Number)element$iv).intValue();
            boolean bl = false;
            if (this.bufferFramesHash.get(newFrameNumber) != null) continue;
            if (this.lastRenderedFrameNumber != -1 && !nextWindowIndexes.contains(this.lastRenderedFrameNumber)) {
                return false;
            }
            Integer n2 = (Integer)oldFramesNumbers.pollFirst();
            if (n2 == null) {
                n2 = -1;
            }
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"oldFramesNumbers.pollFirst() ?: -1");
            int deprecatedFrameNumber = ((Number)n2).intValue();
            CloseableReference<Bitmap> cachedFrame = this.bufferFramesHash.get(deprecatedFrameNumber);
            Object bufferFrame = null;
            CloseableReference bitmapRef = null;
            CloseableReference<Bitmap> closeableReference = cachedFrame;
            CloseableReference closeableReference2 = closeableReference != null && (closeableReference = closeableReference.getBitmapRef()) != null ? closeableReference.cloneOrNull() : (ref = null);
            if (ref != null) {
                bufferFrame = cachedFrame;
                bitmapRef = ref;
            } else {
                CloseableReference closeableReference3 = this.platformBitmapFactory.createBitmap(width, height);
                Intrinsics.checkNotNullExpressionValue((Object)closeableReference3, (String)"platformBitmapFactory.createBitmap(width, height)");
                bufferFrame = new BufferFrame((CloseableReference<Bitmap>)closeableReference3);
                CloseableReference closeableReference4 = ((BufferFrame)bufferFrame).getBitmapRef().clone();
                Intrinsics.checkNotNullExpressionValue((Object)closeableReference4, (String)"bufferFrame.bitmapRef.clone()");
                bitmapRef = closeableReference4;
            }
            ((BufferFrame)bufferFrame).setUpdatingFrame(true);
            Closeable closeable = (Closeable)bitmapRef;
            Serializable serializable = null;
            try {
                CloseableReference it = (CloseableReference)closeable;
                boolean bl2 = false;
                this.obtainFrame((CloseableReference<Bitmap>)it, newFrameNumber, width, height);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
            }
            this.bufferFramesHash.remove(deprecatedFrameNumber);
            ((BufferFrame)bufferFrame).setUpdatingFrame(false);
            serializable = Integer.valueOf(newFrameNumber);
            ((Map)this.bufferFramesHash).put(serializable, bufferFrame);
        }
        if (nextWindow.isEmpty()) {
            n = (int)((float)this.bufferSize * 0.5f);
        } else {
            int windowSize = nextWindow.size();
            int middlePoint = RangesKt.coerceIn((int)((int)((float)windowSize * 0.5f)), (int)0, (int)(windowSize - 1));
            n = ((Number)nextWindow.get(middlePoint)).intValue();
        }
        this.thresholdFrame = n;
        return true;
    }

    static /* synthetic */ boolean extractDemandedFrame$default(BufferFrameLoader bufferFrameLoader, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return bufferFrameLoader.extractDemandedFrame(n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void obtainFrame(CloseableReference<Bitmap> targetBitmap, int targetFrame, int width, int height) {
        Object object;
        CloseableReference nearestFrame = this.findNearestFrame(targetFrame);
        CloseableReference closeableReference = nearestFrame;
        if (closeableReference != null && (closeableReference = closeableReference.getBitmap()) != null && (closeableReference = closeableReference.cloneOrNull()) != null) {
            object = (Closeable)closeableReference;
            Throwable throwable = null;
            try {
                CloseableReference nearestBitmap = (CloseableReference)object;
                boolean bl = false;
                int from = nearestFrame.getFrameNumber();
                if (from < targetFrame) {
                    Object object2 = nearestBitmap.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"nearestBitmap.get()");
                    this.set(targetBitmap, (Bitmap)object2);
                    Iterable $this$forEach$iv = (Iterable)new IntRange(from + 1, targetFrame);
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        Object object3 = targetBitmap.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"targetBitmap.get()");
                        this.bitmapFrameRenderer.renderFrame(it, (Bitmap)object3);
                    }
                    return;
                }
                nearestBitmap = Unit.INSTANCE;
            }
            catch (Throwable nearestBitmap) {
                throwable = nearestBitmap;
                throw nearestBitmap;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        this.clear(targetBitmap);
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, targetFrame);
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)object).nextInt();
            boolean bl = false;
            Object object4 = targetBitmap.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"targetBitmap.get()");
            this.bitmapFrameRenderer.renderFrame(it, (Bitmap)object4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AnimationBitmapFrame findNearestFrame(int targetFrame) {
        AnimationBitmapFrame animationBitmapFrame;
        AnimationBitmapFrame animationBitmapFrame2;
        Iterator iterator = ((Iterable)new IntRange(0, this.frameSequence.getSize())).iterator();
        do {
            if (!iterator.hasNext()) return null;
            int delta = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int closestFrame = this.frameSequence.getPosition(targetFrame - delta);
            BufferFrame bufferFrame = this.bufferFramesHash.get(closestFrame);
            if (bufferFrame != null) {
                BufferFrame bufferFrame2;
                BufferFrame bufferFrame3;
                BufferFrame it = bufferFrame3 = bufferFrame;
                boolean bl2 = false;
                BufferFrame bufferFrame4 = bufferFrame2 = it.isFrameAvailable() ? bufferFrame3 : null;
                if (bufferFrame2 != null) {
                    it = bufferFrame2;
                    boolean bl3 = false;
                    animationBitmapFrame = new AnimationBitmapFrame(closestFrame, it.getBitmapRef());
                    continue;
                }
            }
            animationBitmapFrame = null;
        } while ((animationBitmapFrame2 = animationBitmapFrame) == null);
        AnimationBitmapFrame animationBitmapFrame3 = animationBitmapFrame2;
        return animationBitmapFrame3;
    }

    private final void clear(CloseableReference<Bitmap> $this$clear) {
        if ($this$clear.isValid()) {
            new Canvas((Bitmap)$this$clear.get()).drawColor(0, PorterDuff.Mode.CLEAR);
        }
    }

    private final CloseableReference<Bitmap> set(CloseableReference<Bitmap> $this$set, Bitmap src) {
        if ($this$set.isValid() && !Intrinsics.areEqual((Object)$this$set.get(), (Object)src)) {
            Canvas canvas = new Canvas((Bitmap)$this$set.get());
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
        }
        return $this$set;
    }

    private final int fps(AnimationInformation $this$fps) {
        return (int)RangesKt.coerceAtLeast((long)(TimeUnit.SECONDS.toMillis(1L) / (long)($this$fps.getLoopDurationMs() / $this$fps.getFrameCount())), (long)1L);
    }

    @Override
    public void onStop() {
        FrameLoader.DefaultImpls.onStop(this);
    }

    private static final void loadNextFrames$lambda$2(BufferFrameLoader this$0, int $width, int $height) {
        int targetFrame;
        boolean success;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        while (!(success = BufferFrameLoader.extractDemandedFrame$default(this$0, targetFrame = RangesKt.coerceAtLeast((int)this$0.lastRenderedFrameNumber, (int)0), $width, $height, 0, 8, null))) {
        }
        this$0.isFetching = false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u001a\u0010\u000b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\n\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/BufferFrameLoader$BufferFrame;", "", "bitmapRef", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "(Lcom/facebook/common/references/CloseableReference;)V", "getBitmapRef", "()Lcom/facebook/common/references/CloseableReference;", "isFrameAvailable", "", "()Z", "isUpdatingFrame", "setUpdatingFrame", "(Z)V", "release", "", "animated-drawable_release"})
    private static final class BufferFrame {
        @NotNull
        private final CloseableReference<Bitmap> bitmapRef;
        private boolean isUpdatingFrame;

        public BufferFrame(@NotNull CloseableReference<Bitmap> bitmapRef) {
            Intrinsics.checkNotNullParameter(bitmapRef, (String)"bitmapRef");
            this.bitmapRef = bitmapRef;
        }

        @NotNull
        public final CloseableReference<Bitmap> getBitmapRef() {
            return this.bitmapRef;
        }

        public final boolean isUpdatingFrame() {
            return this.isUpdatingFrame;
        }

        public final void setUpdatingFrame(boolean bl) {
            this.isUpdatingFrame = bl;
        }

        public final boolean isFrameAvailable() {
            return !this.isUpdatingFrame && this.bitmapRef.isValid();
        }

        public final void release() {
            CloseableReference.closeSafely(this.bitmapRef);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/BufferFrameLoader$Companion;", "", "()V", "BUFFER_SECOND_SIZE", "", "THRESHOLD_PERCENTAGE", "", "animated-drawable_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

