/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.frame;

import androidx.annotation.VisibleForTesting;
import com.facebook.fresco.animation.backend.AnimationInformation;
import com.facebook.fresco.animation.frame.FrameScheduler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0007H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/fresco/animation/frame/DropFramesFrameScheduler;", "Lcom/facebook/fresco/animation/frame/FrameScheduler;", "animationInformation", "Lcom/facebook/fresco/animation/backend/AnimationInformation;", "<init>", "(Lcom/facebook/fresco/animation/backend/AnimationInformation;)V", "_loopDurationMs", "", "getFrameNumberToRender", "", "animationTimeMs", "lastFrameTimeMs", "getLoopDurationMs", "getTargetRenderTimeMs", "frameNumber", "getTargetRenderTimeForNextFrameMs", "isInfiniteAnimation", "", "getFrameNumberWithinLoop", "timeInCurrentLoopMs", "Companion", "animated-drawable_release"})
public final class DropFramesFrameScheduler
implements FrameScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimationInformation animationInformation;
    private long _loopDurationMs;
    private static final int UNSET = -1;

    public DropFramesFrameScheduler(@NotNull AnimationInformation animationInformation) {
        Intrinsics.checkNotNullParameter((Object)animationInformation, (String)"animationInformation");
        this.animationInformation = animationInformation;
        this._loopDurationMs = -1L;
    }

    @Override
    public int getFrameNumberToRender(long animationTimeMs, long lastFrameTimeMs) {
        long loopCount;
        long loopDurationMs = this.getLoopDurationMs();
        if (loopDurationMs == 0L) {
            return this.getFrameNumberWithinLoop(0L);
        }
        if (!this.isInfiniteAnimation() && (loopCount = animationTimeMs / loopDurationMs) >= (long)this.animationInformation.getLoopCount()) {
            return -1;
        }
        long timeInCurrentLoopMs = animationTimeMs % loopDurationMs;
        return this.getFrameNumberWithinLoop(timeInCurrentLoopMs);
    }

    @Override
    public long getLoopDurationMs() {
        if (this._loopDurationMs != -1L) {
            return this._loopDurationMs;
        }
        this._loopDurationMs = 0L;
        int frameCount = this.animationInformation.getFrameCount();
        for (int i = 0; i < frameCount; ++i) {
            this._loopDurationMs += (long)this.animationInformation.getFrameDurationMs(i);
        }
        return this._loopDurationMs;
    }

    @Override
    public long getTargetRenderTimeMs(int frameNumber) {
        long targetRenderTimeMs = 0L;
        for (int i = 0; i < frameNumber; ++i) {
            targetRenderTimeMs += (long)this.animationInformation.getFrameDurationMs(frameNumber);
        }
        return targetRenderTimeMs;
    }

    @Override
    public long getTargetRenderTimeForNextFrameMs(long animationTimeMs) {
        long loopCount;
        long loopDurationMs = this.getLoopDurationMs();
        if (loopDurationMs == 0L) {
            return -1L;
        }
        if (!this.isInfiniteAnimation() && (loopCount = animationTimeMs / loopDurationMs) >= (long)this.animationInformation.getLoopCount()) {
            return -1L;
        }
        long timePassedInCurrentLoopMs = animationTimeMs % loopDurationMs;
        long timeOfNextFrameInLoopMs = 0L;
        int frameCount = this.animationInformation.getFrameCount();
        for (int i = 0; i < frameCount && timeOfNextFrameInLoopMs <= timePassedInCurrentLoopMs; timeOfNextFrameInLoopMs += (long)this.animationInformation.getFrameDurationMs(i), ++i) {
        }
        long timeUntilNextFrameInLoopMs = timeOfNextFrameInLoopMs - timePassedInCurrentLoopMs;
        return animationTimeMs + timeUntilNextFrameInLoopMs;
    }

    @Override
    public boolean isInfiniteAnimation() {
        return this.animationInformation.getLoopCount() == 0;
    }

    @VisibleForTesting
    public final int getFrameNumberWithinLoop(long timeInCurrentLoopMs) {
        int frame = 0;
        long currentDuration = 0L;
        while (timeInCurrentLoopMs >= (currentDuration += (long)this.animationInformation.getFrameDurationMs(++frame))) {
        }
        return frame - 1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/fresco/animation/frame/DropFramesFrameScheduler$Companion;", "", "<init>", "()V", "UNSET", "", "animated-drawable_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

