/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.giflite.decoder;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GifMetadataDecoder {
    private static final int MAX_BLOCK_SIZE = 256;
    private static final char[] NETSCAPE = new char[]{'N', 'E', 'T', 'S', 'C', 'A', 'P', 'E', '2', '.', '0'};
    private static final int CONTROL_INDEX_DISPOSE = 0;
    private static final int CONTROL_INDEX_DELAY = 1;
    private final byte[] block = new byte[256];
    private final InputStream mInputStream;
    private final List<int[]> mFrameControls = new ArrayList<int[]>();
    private int mLoopCount = 1;
    private boolean mDecoded = false;

    public static GifMetadataDecoder create(InputStream is) throws IOException {
        GifMetadataDecoder decoder = new GifMetadataDecoder(is);
        decoder.decode();
        return decoder;
    }

    private GifMetadataDecoder(InputStream is) {
        this.mInputStream = is;
    }

    public void decode() throws IOException {
        if (this.mDecoded) {
            throw new IllegalStateException("decode called multiple times");
        }
        this.mDecoded = true;
        this.readGifInfo();
    }

    public int getFrameCount() {
        if (!this.mDecoded) {
            throw new IllegalStateException("getFrameCount called before decode");
        }
        return this.mFrameControls.size();
    }

    public int getLoopCount() {
        if (!this.mDecoded) {
            throw new IllegalStateException("getLoopCount called before decode");
        }
        return this.mLoopCount;
    }

    public int getFrameDisposal(int frameNumber) {
        if (!this.mDecoded) {
            throw new IllegalStateException("getFrameDisposal called before decode");
        }
        return this.mFrameControls.get(frameNumber)[0];
    }

    public int getFrameDurationMs(int frameNumber) {
        if (!this.mDecoded) {
            throw new IllegalStateException("getFrameDurationMs called before decode");
        }
        return this.mFrameControls.get(frameNumber)[1];
    }

    private void readGifInfo() throws IOException {
        this.validateAndIgnoreHeader();
        int[] control = new int[]{0, 0};
        boolean done = false;
        block10: while (!done) {
            int code = this.readNextByte();
            switch (code) {
                case 33: {
                    int extCode = this.readNextByte();
                    switch (extCode) {
                        case 255: {
                            this.readBlock();
                            if (this.isNetscape()) {
                                this.readNetscapeExtension();
                                continue block10;
                            }
                            this.skipExtension();
                            continue block10;
                        }
                        case 249: {
                            this.readGraphicsControlExtension(control);
                            continue block10;
                        }
                        case 1: {
                            this.addFrame(control);
                            this.skipExtension();
                            continue block10;
                        }
                    }
                    this.skipExtension();
                    continue block10;
                }
                case 44: {
                    this.addFrame(control);
                    this.skipImage();
                    continue block10;
                }
                case 59: {
                    done = true;
                    continue block10;
                }
            }
            throw new IOException("Unknown block header [" + Integer.toHexString(code) + "]");
        }
    }

    private void addFrame(int[] control) {
        this.mFrameControls.add(Arrays.copyOf(control, control.length));
    }

    private void validateAndIgnoreHeader() throws IOException {
        boolean valid;
        this.readIntoBlock(0, 6);
        boolean bl = valid = 'G' == (char)this.block[0] && 'I' == (char)this.block[1] && 'F' == (char)this.block[2] && '8' == (char)this.block[3] && ('7' == (char)this.block[4] || '9' == (char)this.block[4]) && 'a' == (char)this.block[5];
        if (!valid) {
            throw new IOException("Illegal header for gif");
        }
        this.readTwoByteInt();
        this.readTwoByteInt();
        int fields = this.readNextByte();
        boolean hasGlobalColorTable = (fields & 0x80) != 0;
        int globalColorTableSize = 2 << (fields & 7);
        this.readNextByte();
        this.readNextByte();
        if (hasGlobalColorTable) {
            this.ignoreColorTable(globalColorTableSize);
        }
    }

    private void ignoreColorTable(int numColors) throws IOException {
        int N = 3 * numColors;
        for (int i = 0; i < N; ++i) {
            this.readNextByte();
        }
    }

    private int readBlock() throws IOException {
        int n;
        int blockSize = this.readNextByte();
        if (blockSize > 0) {
            for (n = 0; n < blockSize; n += this.readIntoBlock(n, blockSize - n)) {
            }
        }
        return n;
    }

    private void skipExtension() throws IOException {
        int size;
        while ((size = this.readBlock()) > 0) {
        }
    }

    private void skipImage() throws IOException {
        boolean hasLct;
        this.readTwoByteInt();
        this.readTwoByteInt();
        this.readTwoByteInt();
        this.readTwoByteInt();
        int flags = this.readNextByte();
        boolean bl = hasLct = (flags & 0x80) != 0;
        if (hasLct) {
            int lctSize = 2 << (flags & 7);
            this.ignoreColorTable(lctSize);
        }
        this.readNextByte();
        this.skipExtension();
    }

    private boolean isNetscape() {
        if (this.block.length < NETSCAPE.length) {
            return false;
        }
        int N = NETSCAPE.length;
        for (int i = 0; i < N; ++i) {
            if (NETSCAPE[i] == (char)this.block[i]) continue;
            return false;
        }
        return true;
    }

    private void readNetscapeExtension() throws IOException {
        int size;
        do {
            size = this.readBlock();
            if (this.block[0] != 1) continue;
            this.mLoopCount = (this.block[2] & 0xFF) << 8 | this.block[1] & 0xFF;
        } while (size > 0);
    }

    private void readGraphicsControlExtension(int[] control) throws IOException {
        this.readNextByte();
        int flags = this.readNextByte();
        control[0] = (flags & 0x1C) >> 2;
        control[1] = this.readTwoByteInt() * 10;
        this.readNextByte();
        this.readNextByte();
    }

    private int readNextByte() throws IOException {
        int read = this.mInputStream.read();
        if (read == -1) {
            throw new EOFException("Unexpected end of gif file");
        }
        return read;
    }

    private int readTwoByteInt() throws IOException {
        return this.readNextByte() | this.readNextByte() << 8;
    }

    private int readIntoBlock(int offset, int length) throws IOException {
        int count = this.mInputStream.read(this.block, offset, length);
        if (count == -1) {
            throw new EOFException("Unexpected end of gif file");
        }
        return count;
    }
}

