/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.giflite.draw;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Movie;
import com.facebook.animated.giflite.draw.MovieScaleHolder;
import javax.annotation.Nullable;

public class MovieDrawer {
    private final Movie mMovie;
    private final MovieScaleHolder mScaleHolder;
    private final Canvas mCanvas;
    @Nullable
    private Bitmap mPreviousBitmap;

    public MovieDrawer(Movie movie) {
        this.mMovie = movie;
        this.mScaleHolder = new MovieScaleHolder(movie.width(), movie.height());
        this.mCanvas = new Canvas();
    }

    public synchronized void drawFrame(int movieTime, int w, int h, Bitmap bitmap) {
        this.mMovie.setTime(movieTime);
        if (this.mPreviousBitmap != null && this.mPreviousBitmap.isRecycled()) {
            this.mPreviousBitmap = null;
        }
        if (this.mPreviousBitmap != bitmap) {
            this.mPreviousBitmap = bitmap;
            this.mCanvas.setBitmap(bitmap);
        }
        this.mScaleHolder.updateViewPort(w, h);
        this.mCanvas.save();
        this.mCanvas.scale(this.mScaleHolder.getScale(), this.mScaleHolder.getScale());
        this.mMovie.draw(this.mCanvas, this.mScaleHolder.getLeft(), this.mScaleHolder.getTop());
        this.mCanvas.restore();
    }
}

