/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.giflite.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Movie;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.facebook.animated.giflite.decoder.GifMetadataDecoder;
import com.facebook.fresco.animation.backend.AnimationBackend;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

public class GifAnimationBackend
implements AnimationBackend {
    private final GifMetadataDecoder mGifDecoder;
    private final Movie mMovie;
    private final int[] mFrameStartTimes;
    private float mMidX;
    private float mMidY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GifAnimationBackend create(String filePath) throws IOException {
        GifAnimationBackend gifAnimationBackend;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(filePath));
            ((InputStream)is).mark(Integer.MAX_VALUE);
            GifMetadataDecoder decoder = GifMetadataDecoder.create(is);
            ((InputStream)is).reset();
            Movie movie = Movie.decodeStream((InputStream)is);
            gifAnimationBackend = new GifAnimationBackend(decoder, movie);
        }
        catch (Throwable throwable) {
            GifAnimationBackend.closeSilently(is);
            throw throwable;
        }
        GifAnimationBackend.closeSilently(is);
        return gifAnimationBackend;
    }

    private GifAnimationBackend(GifMetadataDecoder decoder, Movie movie) {
        this.mGifDecoder = decoder;
        this.mMovie = movie;
        this.mFrameStartTimes = new int[decoder.getFrameCount()];
    }

    public boolean drawFrame(Drawable parent, Canvas canvas, int frameNumber) {
        this.mMovie.setTime(this.getFrameStartTime(frameNumber));
        this.mMovie.draw(canvas, this.mMidX, this.mMidY);
        return true;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public void setBounds(Rect bounds) {
        this.scale(bounds.right - bounds.left, bounds.bottom - bounds.top, this.mMovie.width(), this.mMovie.height());
    }

    public int getIntrinsicWidth() {
        return this.mMovie.width();
    }

    public int getIntrinsicHeight() {
        return this.mMovie.height();
    }

    public int getSizeInBytes() {
        return 0;
    }

    public void clear() {
    }

    public int getFrameCount() {
        return this.mGifDecoder.getFrameCount();
    }

    public int getFrameDurationMs(int frameNumber) {
        return this.mGifDecoder.getFrameDurationMs(frameNumber);
    }

    public int getLoopCount() {
        return this.mGifDecoder.getLoopCount();
    }

    private int getFrameStartTime(int frameNumber) {
        if (frameNumber == 0) {
            return 0;
        }
        if (this.mFrameStartTimes[frameNumber] != 0) {
            return this.mFrameStartTimes[frameNumber];
        }
        for (int i = 0; i < frameNumber; ++i) {
            int n = frameNumber;
            this.mFrameStartTimes[n] = this.mFrameStartTimes[n] + this.mGifDecoder.getFrameDurationMs(i);
        }
        return this.mFrameStartTimes[frameNumber];
    }

    private void scale(int viewPortWidth, int viewPortHeight, int sourceWidth, int sourceHeight) {
        float inputRatio = (float)sourceWidth / (float)sourceHeight;
        float outputRatio = (float)viewPortWidth / (float)viewPortHeight;
        int scaledWidth = viewPortWidth;
        int scaledHeight = viewPortHeight;
        if (outputRatio > inputRatio) {
            scaledWidth = (int)((float)viewPortHeight * inputRatio);
            scaledHeight = viewPortHeight;
        } else if (outputRatio < inputRatio) {
            scaledHeight = (int)((float)viewPortWidth / inputRatio);
            scaledWidth = viewPortWidth;
        }
        float scale = (float)scaledWidth / (float)sourceWidth;
        this.mMidX = (float)(viewPortWidth - scaledWidth) / 2.0f / scale;
        this.mMidY = (float)(viewPortHeight - scaledHeight) / 2.0f / scale;
    }

    private static void closeSilently(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

