/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.giflite.draw;

import com.facebook.animated.giflite.draw.MovieFrame;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageFrame;

public class MovieAnimatedImage
implements AnimatedImage {
    private final MovieFrame[] mFrames;
    private final int mSizeInBytes;
    private final int mDuration;
    private final int mLoopCount;
    private final int[] mFrameDurations;

    public MovieAnimatedImage(MovieFrame[] frames, int sizeInBytes, int duration, int loopCount) {
        this.mFrames = frames;
        this.mSizeInBytes = sizeInBytes;
        this.mDuration = duration;
        this.mLoopCount = loopCount;
        this.mFrameDurations = new int[this.mFrames.length];
        int N = this.mFrames.length;
        for (int i = 0; i < N; ++i) {
            this.mFrameDurations[i] = this.mFrames[i].getDurationMs();
        }
    }

    public void dispose() {
    }

    public int getWidth() {
        return this.mFrames[0].getWidth();
    }

    public int getHeight() {
        return this.mFrames[0].getHeight();
    }

    public int getFrameCount() {
        return this.mFrames.length;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public int[] getFrameDurations() {
        return this.mFrameDurations;
    }

    public int getLoopCount() {
        return this.mLoopCount;
    }

    public AnimatedImageFrame getFrame(int frameNumber) {
        return this.mFrames[frameNumber];
    }

    public boolean doesRenderSupportScaling() {
        return true;
    }

    public int getSizeInBytes() {
        return this.mSizeInBytes;
    }

    public AnimatedDrawableFrameInfo getFrameInfo(int frameNumber) {
        MovieFrame frame = this.mFrames[frameNumber];
        return new AnimatedDrawableFrameInfo(frameNumber, frame.getXOffset(), frame.getYOffset(), frame.getWidth(), frame.getHeight(), AnimatedDrawableFrameInfo.BlendOperation.BLEND_WITH_PREVIOUS, this.mFrames[frameNumber].getDisposalMode());
    }
}

