/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.giflite.draw;

class MovieScaleHolder {
    private final int mMovieWidth;
    private final int mMovieHeight;
    private int mViewPortWidth;
    private int mViewPortHeight;
    private float mScale = 1.0f;
    private float mLeft = 0.0f;
    private float mTop = 0.0f;

    public MovieScaleHolder(int movieWidth, int movieHeight) {
        this.mMovieWidth = movieWidth;
        this.mMovieHeight = movieHeight;
    }

    public synchronized float getScale() {
        return this.mScale;
    }

    public synchronized float getLeft() {
        return this.mLeft;
    }

    public synchronized float getTop() {
        return this.mTop;
    }

    public synchronized void updateViewPort(int viewPortWidth, int viewPortHeight) {
        if (this.mViewPortWidth == viewPortWidth && this.mViewPortHeight == viewPortHeight) {
            return;
        }
        this.mViewPortWidth = viewPortWidth;
        this.mViewPortHeight = viewPortHeight;
        this.determineScaleAndPosition();
    }

    private synchronized void determineScaleAndPosition() {
        float inputRatio = this.mMovieWidth / this.mMovieHeight;
        float outputRatio = this.mViewPortWidth / this.mViewPortHeight;
        int width = this.mViewPortWidth;
        int height = this.mViewPortHeight;
        if (outputRatio > inputRatio) {
            width = (int)((float)this.mViewPortHeight * inputRatio);
        } else if (outputRatio < inputRatio) {
            height = (int)((float)this.mViewPortWidth / inputRatio);
        }
        this.mScale = this.mViewPortWidth > this.mMovieWidth ? (float)this.mMovieWidth / (float)this.mViewPortWidth : (this.mMovieWidth > this.mViewPortWidth ? (float)this.mViewPortWidth / (float)this.mMovieWidth : 1.0f);
        this.mLeft = (float)(this.mViewPortWidth - width) / 2.0f / this.mScale;
        this.mTop = (float)(this.mViewPortHeight - height) / 2.0f / this.mScale;
    }
}

