/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.giflite;

import android.graphics.Movie;
import com.facebook.animated.giflite.decoder.GifMetadataDecoder;
import com.facebook.animated.giflite.draw.MovieAnimatedImage;
import com.facebook.animated.giflite.draw.MovieDrawer;
import com.facebook.animated.giflite.draw.MovieFrame;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.image.CloseableAnimatedImage;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.QualityInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GifDecoder
implements ImageDecoder {
    public CloseableImage decode(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        InputStream is = encodedImage.getInputStream();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GifMetadataDecoder decoder = GifMetadataDecoder.create(is, out);
            if (out.size() > 0) {
                is.close();
                is = new ByteArrayInputStream(out.toByteArray());
            }
            is.reset();
            Movie movie = Movie.decodeStream((InputStream)is);
            MovieDrawer drawer = new MovieDrawer(movie);
            MovieFrame[] frames = new MovieFrame[decoder.getFrameCount()];
            int currTime = 0;
            int N = frames.length;
            for (int frameNumber = 0; frameNumber < N; ++frameNumber) {
                int frameDuration = decoder.getFrameDurationMs(frameNumber);
                frames[frameNumber] = new MovieFrame(drawer, currTime += frameDuration, frameDuration, movie.width(), movie.height(), GifDecoder.translateFrameDisposal(decoder.getFrameDisposal(frameNumber)));
            }
            CloseableAnimatedImage closeableAnimatedImage = new CloseableAnimatedImage(AnimatedImageResult.forAnimatedImage((AnimatedImage)new MovieAnimatedImage(frames, encodedImage.getSize(), movie.duration(), decoder.getLoopCount())), false);
            return closeableAnimatedImage;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while decoding gif", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static AnimatedDrawableFrameInfo.DisposalMethod translateFrameDisposal(int raw) {
        switch (raw) {
            case 2: {
                return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND;
            }
            case 3: {
                return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_PREVIOUS;
            }
        }
        return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT;
    }
}

