/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.gif;

import com.facebook.animated.gif.GifFrame;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.factory.AnimatedImageDecoder;
import com.facebook.soloader.SoLoader;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@DoNotStrip
public class GifImage
implements AnimatedImage,
AnimatedImageDecoder {
    private static final int LOOP_COUNT_FOREVER = 0;
    private static final int LOOP_COUNT_MISSING = -1;
    private static volatile boolean sInitialized;
    @DoNotStrip
    private long mNativeContext;

    private static synchronized void ensure() {
        if (!sInitialized) {
            sInitialized = true;
            SoLoader.loadLibrary((String)"gifimage");
        }
    }

    public static GifImage create(byte[] source) {
        GifImage.ensure();
        Preconditions.checkNotNull((Object)source);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(source.length);
        byteBuffer.put(source);
        byteBuffer.rewind();
        return GifImage.nativeCreateFromDirectByteBuffer(byteBuffer);
    }

    public static GifImage create(ByteBuffer byteBuffer) {
        GifImage.ensure();
        byteBuffer.rewind();
        return GifImage.nativeCreateFromDirectByteBuffer(byteBuffer);
    }

    public static GifImage create(long nativePtr, int sizeInBytes) {
        GifImage.ensure();
        Preconditions.checkArgument((nativePtr != 0L ? 1 : 0) != 0);
        return GifImage.nativeCreateFromNativeMemory(nativePtr, sizeInBytes);
    }

    public AnimatedImage decode(long nativePtr, int sizeInBytes) {
        return GifImage.create(nativePtr, sizeInBytes);
    }

    public AnimatedImage decode(ByteBuffer byteBuffer) {
        return GifImage.create(byteBuffer);
    }

    @DoNotStrip
    public GifImage() {
    }

    @DoNotStrip
    GifImage(long nativeContext) {
        this.mNativeContext = nativeContext;
    }

    protected void finalize() {
        this.nativeFinalize();
    }

    public void dispose() {
        this.nativeDispose();
    }

    public int getWidth() {
        return this.nativeGetWidth();
    }

    public int getHeight() {
        return this.nativeGetHeight();
    }

    public int getFrameCount() {
        return this.nativeGetFrameCount();
    }

    public int getDuration() {
        return this.nativeGetDuration();
    }

    public int[] getFrameDurations() {
        return this.nativeGetFrameDurations();
    }

    public int getLoopCount() {
        int loopCount = this.nativeGetLoopCount();
        switch (loopCount) {
            case 0: {
                return 0;
            }
            case -1: {
                return 1;
            }
        }
        return loopCount + 1;
    }

    public GifFrame getFrame(int frameNumber) {
        return this.nativeGetFrame(frameNumber);
    }

    public boolean doesRenderSupportScaling() {
        return false;
    }

    public int getSizeInBytes() {
        return this.nativeGetSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimatedDrawableFrameInfo getFrameInfo(int frameNumber) {
        GifFrame frame = this.getFrame(frameNumber);
        try {
            AnimatedDrawableFrameInfo animatedDrawableFrameInfo = new AnimatedDrawableFrameInfo(frameNumber, frame.getXOffset(), frame.getYOffset(), frame.getWidth(), frame.getHeight(), AnimatedDrawableFrameInfo.BlendOperation.BLEND_WITH_PREVIOUS, GifImage.fromGifDisposalMethod(frame.getDisposalMode()));
            return animatedDrawableFrameInfo;
        }
        finally {
            frame.dispose();
        }
    }

    private static AnimatedDrawableFrameInfo.DisposalMethod fromGifDisposalMethod(int disposalMode) {
        if (disposalMode == 0) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT;
        }
        if (disposalMode == 1) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT;
        }
        if (disposalMode == 2) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND;
        }
        if (disposalMode == 3) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_PREVIOUS;
        }
        return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT;
    }

    @DoNotStrip
    private static native GifImage nativeCreateFromDirectByteBuffer(ByteBuffer var0);

    @DoNotStrip
    private static native GifImage nativeCreateFromNativeMemory(long var0, int var2);

    @DoNotStrip
    private native int nativeGetWidth();

    @DoNotStrip
    private native int nativeGetHeight();

    @DoNotStrip
    private native int nativeGetDuration();

    @DoNotStrip
    private native int nativeGetFrameCount();

    @DoNotStrip
    private native int[] nativeGetFrameDurations();

    @DoNotStrip
    private native int nativeGetLoopCount();

    @DoNotStrip
    private native GifFrame nativeGetFrame(int var1);

    @DoNotStrip
    private native int nativeGetSizeInBytes();

    @DoNotStrip
    private native void nativeDispose();

    @DoNotStrip
    private native void nativeFinalize();
}

