/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.drawee.drawable.DrawableUtils;
import com.facebook.drawee.drawable.Rounded;
import java.util.Arrays;
import javax.annotation.Nullable;

public class RoundedColorDrawable
extends Drawable
implements Rounded {
    private final float[] mRadii = new float[8];
    @VisibleForTesting
    final float[] mBorderRadii = new float[8];
    @Nullable
    @VisibleForTesting
    float[] mInsideBorderRadii;
    @VisibleForTesting
    final Paint mPaint = new Paint(1);
    private boolean mIsCircle = false;
    private float mBorderWidth = 0.0f;
    private float mPadding = 0.0f;
    private int mBorderColor = 0;
    private boolean mScaleDownInsideBorders = false;
    private boolean mPaintFilterBitmap = false;
    @VisibleForTesting
    final Path mPath = new Path();
    @VisibleForTesting
    final Path mBorderPath = new Path();
    private int mColor = 0;
    private final RectF mTempRect = new RectF();
    private int mAlpha = 255;

    public RoundedColorDrawable(int color) {
        this.setColor(color);
    }

    @TargetApi(value=11)
    public static RoundedColorDrawable fromColorDrawable(ColorDrawable colorDrawable) {
        return new RoundedColorDrawable(colorDrawable.getColor());
    }

    public RoundedColorDrawable(float[] radii, int color) {
        this(color);
        this.setRadii(radii);
    }

    public RoundedColorDrawable(float radius, int color) {
        this(color);
        this.setRadius(radius);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updatePath();
    }

    public void draw(Canvas canvas) {
        this.mPaint.setColor(DrawableUtils.multiplyColorAlpha(this.mColor, this.mAlpha));
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setFilterBitmap(this.getPaintFilterBitmap());
        canvas.drawPath(this.mPath, this.mPaint);
        if (this.mBorderWidth != 0.0f) {
            this.mPaint.setColor(DrawableUtils.multiplyColorAlpha(this.mBorderColor, this.mAlpha));
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(this.mBorderWidth);
            canvas.drawPath(this.mBorderPath, this.mPaint);
        }
    }

    @Override
    public void setCircle(boolean isCircle) {
        this.mIsCircle = isCircle;
        this.updatePath();
        this.invalidateSelf();
    }

    @Override
    public boolean isCircle() {
        return this.mIsCircle;
    }

    @Override
    public void setRadii(float[] radii) {
        if (radii == null) {
            Arrays.fill(this.mRadii, 0.0f);
        } else {
            Preconditions.checkArgument((radii.length == 8 ? 1 : 0) != 0, (Object)"radii should have exactly 8 values");
            System.arraycopy(radii, 0, this.mRadii, 0, 8);
        }
        this.updatePath();
        this.invalidateSelf();
    }

    @Override
    public float[] getRadii() {
        return this.mRadii;
    }

    @Override
    public void setRadius(float radius) {
        Preconditions.checkArgument((radius >= 0.0f ? 1 : 0) != 0, (Object)"radius should be non negative");
        Arrays.fill(this.mRadii, radius);
        this.updatePath();
        this.invalidateSelf();
    }

    public void setColor(int color) {
        if (this.mColor != color) {
            this.mColor = color;
            this.invalidateSelf();
        }
    }

    public int getColor() {
        return this.mColor;
    }

    @Override
    public void setBorder(int color, float width) {
        if (this.mBorderColor != color) {
            this.mBorderColor = color;
            this.invalidateSelf();
        }
        if (this.mBorderWidth != width) {
            this.mBorderWidth = width;
            this.updatePath();
            this.invalidateSelf();
        }
    }

    @Override
    public int getBorderColor() {
        return this.mBorderColor;
    }

    @Override
    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    @Override
    public void setPadding(float padding) {
        if (this.mPadding != padding) {
            this.mPadding = padding;
            this.updatePath();
            this.invalidateSelf();
        }
    }

    @Override
    public float getPadding() {
        return this.mPadding;
    }

    @Override
    public void setScaleDownInsideBorders(boolean scaleDownInsideBorders) {
        if (this.mScaleDownInsideBorders != scaleDownInsideBorders) {
            this.mScaleDownInsideBorders = scaleDownInsideBorders;
            this.updatePath();
            this.invalidateSelf();
        }
    }

    @Override
    public boolean getScaleDownInsideBorders() {
        return this.mScaleDownInsideBorders;
    }

    @Override
    public void setPaintFilterBitmap(boolean paintFilterBitmap) {
        if (this.mPaintFilterBitmap != paintFilterBitmap) {
            this.mPaintFilterBitmap = paintFilterBitmap;
            this.invalidateSelf();
        }
    }

    @Override
    public boolean getPaintFilterBitmap() {
        return this.mPaintFilterBitmap;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return DrawableUtils.getOpacityFromColor(DrawableUtils.multiplyColorAlpha(this.mColor, this.mAlpha));
    }

    private void updatePath() {
        this.mPath.reset();
        this.mBorderPath.reset();
        this.mTempRect.set(this.getBounds());
        this.mTempRect.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
        if (this.mIsCircle) {
            float radius = Math.min(this.mTempRect.width(), this.mTempRect.height()) / 2.0f;
            this.mBorderPath.addCircle(this.mTempRect.centerX(), this.mTempRect.centerY(), radius, Path.Direction.CW);
        } else {
            for (int i = 0; i < this.mBorderRadii.length; ++i) {
                this.mBorderRadii[i] = this.mRadii[i] + this.mPadding - this.mBorderWidth / 2.0f;
            }
            this.mBorderPath.addRoundRect(this.mTempRect, this.mBorderRadii, Path.Direction.CW);
        }
        this.mTempRect.inset(-this.mBorderWidth / 2.0f, -this.mBorderWidth / 2.0f);
        float totalPadding = this.mPadding + (this.mScaleDownInsideBorders ? this.mBorderWidth : 0.0f);
        this.mTempRect.inset(totalPadding, totalPadding);
        if (this.mIsCircle) {
            float radius = Math.min(this.mTempRect.width(), this.mTempRect.height()) / 2.0f;
            this.mPath.addCircle(this.mTempRect.centerX(), this.mTempRect.centerY(), radius, Path.Direction.CW);
        } else if (this.mScaleDownInsideBorders) {
            if (this.mInsideBorderRadii == null) {
                this.mInsideBorderRadii = new float[8];
            }
            for (int i = 0; i < this.mInsideBorderRadii.length; ++i) {
                this.mInsideBorderRadii[i] = this.mRadii[i] - this.mBorderWidth;
            }
            this.mPath.addRoundRect(this.mTempRect, this.mInsideBorderRadii, Path.Direction.CW);
        } else {
            this.mPath.addRoundRect(this.mTempRect, this.mRadii, Path.Direction.CW);
        }
        this.mTempRect.inset(-totalPadding, -totalPadding);
    }
}

