/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.components;

import android.os.Handler;
import android.os.Looper;
import com.facebook.common.internal.Preconditions;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class DeferredReleaser {
    @Nullable
    private static DeferredReleaser sInstance = null;
    private final Set<Releasable> mPendingReleasables;
    private final Handler mUiHandler;
    private final Runnable releaseRunnable = new Runnable(){

        @Override
        public void run() {
            DeferredReleaser.ensureOnUiThread();
            for (Releasable releasable : DeferredReleaser.this.mPendingReleasables) {
                releasable.release();
            }
            DeferredReleaser.this.mPendingReleasables.clear();
        }
    };

    public static synchronized DeferredReleaser getInstance() {
        if (sInstance == null) {
            sInstance = new DeferredReleaser();
        }
        return sInstance;
    }

    public DeferredReleaser() {
        this.mPendingReleasables = new HashSet<Releasable>();
        this.mUiHandler = new Handler(Looper.getMainLooper());
    }

    public void scheduleDeferredRelease(Releasable releasable) {
        DeferredReleaser.ensureOnUiThread();
        if (!this.mPendingReleasables.add(releasable)) {
            return;
        }
        if (this.mPendingReleasables.size() == 1) {
            this.mUiHandler.post(this.releaseRunnable);
        }
    }

    public void cancelDeferredRelease(Releasable releasable) {
        DeferredReleaser.ensureOnUiThread();
        this.mPendingReleasables.remove(releasable);
    }

    private static void ensureOnUiThread() {
        Preconditions.checkState((Looper.getMainLooper().getThread() == Thread.currentThread() ? 1 : 0) != 0);
    }

    public static interface Releasable {
        public void release();
    }
}

