/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.VisibleForTesting;
import com.facebook.drawee.drawable.DrawableUtils;
import com.facebook.drawee.drawable.RoundedDrawable;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;

public class RoundedBitmapDrawable
extends RoundedDrawable {
    private final Paint mPaint = new Paint();
    private final Paint mBorderPaint = new Paint(1);
    @Nullable
    private final Bitmap mBitmap;
    @Nullable
    private WeakReference<Bitmap> mLastBitmap;

    public RoundedBitmapDrawable(Resources res, @Nullable Bitmap bitmap, @Nullable Paint paint) {
        super((Drawable)new BitmapDrawable(res, bitmap));
        this.mBitmap = bitmap;
        if (paint != null) {
            this.mPaint.set(paint);
        }
        this.mPaint.setFlags(1);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
    }

    public RoundedBitmapDrawable(Resources res, @Nullable Bitmap bitmap) {
        this(res, bitmap, null);
    }

    @Override
    public void draw(Canvas canvas) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"RoundedBitmapDrawable#draw");
        }
        if (!this.shouldRound()) {
            super.draw(canvas);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
            return;
        }
        this.updateTransform();
        this.updatePath();
        this.updatePaint();
        int saveCount = canvas.save();
        canvas.concat(this.mInverseParentTransform);
        canvas.drawPath(this.mPath, this.mPaint);
        if (this.mBorderWidth > 0.0f) {
            this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
            this.mBorderPaint.setColor(DrawableUtils.multiplyColorAlpha(this.mBorderColor, this.mPaint.getAlpha()));
            canvas.drawPath(this.mBorderPath, this.mBorderPaint);
        }
        canvas.restoreToCount(saveCount);
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    private void updatePaint() {
        if (this.mLastBitmap == null || this.mLastBitmap.get() != this.mBitmap) {
            this.mLastBitmap = new WeakReference<Bitmap>(this.mBitmap);
            this.mPaint.setShader((Shader)new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            this.mIsShaderTransformDirty = true;
        }
        if (this.mIsShaderTransformDirty) {
            this.mPaint.getShader().setLocalMatrix(this.mTransform);
            this.mIsShaderTransformDirty = false;
        }
        this.mPaint.setFilterBitmap(this.getPaintFilterBitmap());
    }

    public static RoundedBitmapDrawable fromBitmapDrawable(Resources res, BitmapDrawable bitmapDrawable) {
        return new RoundedBitmapDrawable(res, bitmapDrawable.getBitmap(), bitmapDrawable.getPaint());
    }

    @Override
    @VisibleForTesting
    boolean shouldRound() {
        return super.shouldRound() && this.mBitmap != null;
    }

    @Override
    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
        if (alpha != this.mPaint.getAlpha()) {
            this.mPaint.setAlpha(alpha);
            super.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        super.setColorFilter(colorFilter);
        this.mPaint.setColorFilter(colorFilter);
    }

    Paint getPaint() {
        return this.mPaint;
    }
}

