/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.facebook.drawee.drawable.DrawableParent;
import com.facebook.drawee.drawable.DrawableProperties;
import com.facebook.drawee.drawable.DrawableUtils;
import com.facebook.drawee.drawable.TransformAwareDrawable;
import com.facebook.drawee.drawable.TransformCallback;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ForwardingDrawable
extends Drawable
implements Drawable.Callback,
TransformCallback,
TransformAwareDrawable,
DrawableParent {
    @Nullable
    private Drawable mCurrentDelegate;
    private final DrawableProperties mDrawableProperties = new DrawableProperties();
    @Nullable
    protected TransformCallback mTransformCallback;
    private static final Matrix sTempTransform = new Matrix();

    public ForwardingDrawable(@Nullable Drawable drawable) {
        this.mCurrentDelegate = drawable;
        DrawableUtils.setCallbacks(this.mCurrentDelegate, this, this);
    }

    @Nullable
    public Drawable setCurrent(@Nullable Drawable newDelegate) {
        Drawable previousDelegate = this.setCurrentWithoutInvalidate(newDelegate);
        this.invalidateSelf();
        return previousDelegate;
    }

    @Nullable
    protected Drawable setCurrentWithoutInvalidate(@Nullable Drawable newDelegate) {
        Drawable previousDelegate = this.mCurrentDelegate;
        DrawableUtils.setCallbacks(previousDelegate, null, null);
        DrawableUtils.setCallbacks(newDelegate, null, null);
        DrawableUtils.setDrawableProperties(newDelegate, this.mDrawableProperties);
        DrawableUtils.copyProperties(newDelegate, this);
        DrawableUtils.setCallbacks(newDelegate, this, this);
        this.mCurrentDelegate = newDelegate;
        return previousDelegate;
    }

    public int getOpacity() {
        if (this.mCurrentDelegate == null) {
            return 0;
        }
        return this.mCurrentDelegate.getOpacity();
    }

    public void setAlpha(int alpha) {
        this.mDrawableProperties.setAlpha(alpha);
        if (this.mCurrentDelegate != null) {
            this.mCurrentDelegate.setAlpha(alpha);
        }
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mDrawableProperties.setColorFilter(colorFilter);
        if (this.mCurrentDelegate != null) {
            this.mCurrentDelegate.setColorFilter(colorFilter);
        }
    }

    public void setDither(boolean dither) {
        this.mDrawableProperties.setDither(dither);
        if (this.mCurrentDelegate != null) {
            this.mCurrentDelegate.setDither(dither);
        }
    }

    public void setFilterBitmap(boolean filterBitmap) {
        this.mDrawableProperties.setFilterBitmap(filterBitmap);
        if (this.mCurrentDelegate != null) {
            this.mCurrentDelegate.setFilterBitmap(filterBitmap);
        }
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean superResult = super.setVisible(visible, restart);
        if (this.mCurrentDelegate == null) {
            return superResult;
        }
        return this.mCurrentDelegate.setVisible(visible, restart);
    }

    protected void onBoundsChange(Rect bounds) {
        if (this.mCurrentDelegate != null) {
            this.mCurrentDelegate.setBounds(bounds);
        }
    }

    @Nullable
    public Drawable.ConstantState getConstantState() {
        if (this.mCurrentDelegate == null) {
            return super.getConstantState();
        }
        return this.mCurrentDelegate.getConstantState();
    }

    public boolean isStateful() {
        if (this.mCurrentDelegate == null) {
            return false;
        }
        return this.mCurrentDelegate.isStateful();
    }

    protected boolean onStateChange(int[] state) {
        if (this.mCurrentDelegate == null) {
            return super.onStateChange(state);
        }
        return this.mCurrentDelegate.setState(state);
    }

    protected boolean onLevelChange(int level) {
        if (this.mCurrentDelegate == null) {
            return super.onLevelChange(level);
        }
        return this.mCurrentDelegate.setLevel(level);
    }

    public void draw(Canvas canvas) {
        if (this.mCurrentDelegate != null) {
            this.mCurrentDelegate.draw(canvas);
        }
    }

    public int getIntrinsicWidth() {
        if (this.mCurrentDelegate == null) {
            return super.getIntrinsicWidth();
        }
        return this.mCurrentDelegate.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        if (this.mCurrentDelegate == null) {
            return super.getIntrinsicHeight();
        }
        return this.mCurrentDelegate.getIntrinsicHeight();
    }

    public boolean getPadding(Rect padding) {
        if (this.mCurrentDelegate == null) {
            return super.getPadding(padding);
        }
        return this.mCurrentDelegate.getPadding(padding);
    }

    public Drawable mutate() {
        if (this.mCurrentDelegate != null) {
            this.mCurrentDelegate.mutate();
        }
        return this;
    }

    @Nullable
    public Drawable getCurrent() {
        return this.mCurrentDelegate;
    }

    @Override
    @Nullable
    public Drawable setDrawable(@Nullable Drawable newDrawable) {
        return this.setCurrent(newDrawable);
    }

    @Override
    @Nullable
    public Drawable getDrawable() {
        return this.getCurrent();
    }

    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    @Override
    public void setTransformCallback(TransformCallback transformCallback) {
        this.mTransformCallback = transformCallback;
    }

    protected void getParentTransform(Matrix transform) {
        if (this.mTransformCallback != null) {
            this.mTransformCallback.getTransform(transform);
        } else {
            transform.reset();
        }
    }

    @Override
    public void getTransform(Matrix transform) {
        this.getParentTransform(transform);
    }

    @Override
    public void getRootBounds(RectF bounds) {
        if (this.mTransformCallback != null) {
            this.mTransformCallback.getRootBounds(bounds);
        } else {
            bounds.set(this.getBounds());
        }
    }

    public void getTransformedBounds(RectF outBounds) {
        this.getParentTransform(sTempTransform);
        outBounds.set(this.getBounds());
        sTempTransform.mapRect(outBounds);
    }

    @TargetApi(value=21)
    public void setHotspot(float x, float y) {
        if (this.mCurrentDelegate != null) {
            this.mCurrentDelegate.setHotspot(x, y);
        }
    }
}

