/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.facebook.drawee.drawable.CloneableDrawable;
import com.facebook.drawee.drawable.DrawableUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fJ\u0010\u0010$\u001a\u00020\u00132\u0006\u0010#\u001a\u00020%H\u0016J\u000e\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u0013J\u0010\u00100\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\fH\u0014J\u0010\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\fH\u0016J\u0012\u00103\u001a\u00020\"2\b\u00104\u001a\u0004\u0018\u000105H\u0016J\b\u00106\u001a\u00020\fH\u0016J\u0010\u00107\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0016J\n\u0010:\u001a\u0004\u0018\u00010\u0001H\u0016J \u0010;\u001a\u00020\"2\u0006\u00108\u001a\u0002092\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J \u0010<\u001a\u00020\"2\u0006\u00108\u001a\u0002092\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0018\u0010=\u001a\u00020\"2\u0006\u00108\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR$\u0010&\u001a\u00020\f2\u0006\u0010&\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u001b\"\u0004\b(\u0010\u001dR$\u0010)\u001a\u00020\f2\u0006\u0010)\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010\u001b\"\u0004\b+\u0010\u001dR$\u0010,\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\u0015\"\u0004\b-\u0010\u0017\u00a8\u0006>"}, d2={"Lcom/facebook/drawee/drawable/ProgressBarDrawable;", "Landroid/graphics/drawable/Drawable;", "Lcom/facebook/drawee/drawable/CloneableDrawable;", "<init>", "()V", "paint", "Landroid/graphics/Paint;", "path", "Landroid/graphics/Path;", "rect", "Landroid/graphics/RectF;", "_backgroundColor", "", "_color", "_padding", "_barWidth", "level", "_radius", "hideWhenZero", "", "getHideWhenZero", "()Z", "setHideWhenZero", "(Z)V", "_isVertical", "color", "getColor", "()I", "setColor", "(I)V", "backgroundColor", "getBackgroundColor", "setBackgroundColor", "setPadding", "", "padding", "getPadding", "Landroid/graphics/Rect;", "barWidth", "getBarWidth", "setBarWidth", "radius", "getRadius", "setRadius", "isVertical", "setVertical", "setIsVertical", "value", "onLevelChange", "setAlpha", "alpha", "setColorFilter", "cf", "Landroid/graphics/ColorFilter;", "getOpacity", "draw", "canvas", "Landroid/graphics/Canvas;", "cloneDrawable", "drawHorizontalBar", "drawVerticalBar", "drawBar", "drawee_release"})
public final class ProgressBarDrawable
extends Drawable
implements CloneableDrawable {
    @NotNull
    private final Paint paint = new Paint(1);
    @NotNull
    private final Path path = new Path();
    @NotNull
    private final RectF rect = new RectF();
    private int _backgroundColor = Integer.MIN_VALUE;
    private int _color = -2147450625;
    private int _padding = 10;
    private int _barWidth = 20;
    private int level;
    private int _radius;
    private boolean hideWhenZero;
    private boolean _isVertical;

    public final boolean getHideWhenZero() {
        return this.hideWhenZero;
    }

    public final void setHideWhenZero(boolean bl) {
        this.hideWhenZero = bl;
    }

    public final int getColor() {
        return this._color;
    }

    public final void setColor(int color) {
        if (this._color != color) {
            this._color = color;
            this.invalidateSelf();
        }
    }

    public final int getBackgroundColor() {
        return this._backgroundColor;
    }

    public final void setBackgroundColor(int backgroundColor) {
        if (this._backgroundColor != backgroundColor) {
            this._backgroundColor = backgroundColor;
            this.invalidateSelf();
        }
    }

    public final void setPadding(int padding) {
        if (this._padding != padding) {
            this._padding = padding;
            this.invalidateSelf();
        }
    }

    public boolean getPadding(@NotNull Rect padding) {
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        padding.set(this._padding, this._padding, this._padding, this._padding);
        return this._padding != 0;
    }

    public final int getBarWidth() {
        return this._barWidth;
    }

    public final void setBarWidth(int barWidth) {
        if (this._barWidth != barWidth) {
            this._barWidth = barWidth;
            this.invalidateSelf();
        }
    }

    public final int getRadius() {
        return this._radius;
    }

    public final void setRadius(int radius) {
        if (this._radius != radius) {
            this._radius = radius;
            this.invalidateSelf();
        }
    }

    public final boolean isVertical() {
        return this._isVertical;
    }

    public final void setVertical(boolean isVertical) {
        if (this._isVertical != isVertical) {
            this._isVertical = isVertical;
            this.invalidateSelf();
        }
    }

    public final void setIsVertical(boolean value) {
        this.setVertical(value);
    }

    protected boolean onLevelChange(int level) {
        this.level = level;
        this.invalidateSelf();
        return true;
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter cf) {
        this.paint.setColorFilter(cf);
    }

    public int getOpacity() {
        return DrawableUtils.getOpacityFromColor(this.paint.getColor());
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.hideWhenZero && this.level == 0) {
            return;
        }
        if (this._isVertical) {
            this.drawVerticalBar(canvas, 10000, this._backgroundColor);
            this.drawVerticalBar(canvas, this.level, this._color);
        } else {
            this.drawHorizontalBar(canvas, 10000, this._backgroundColor);
            this.drawHorizontalBar(canvas, this.level, this._color);
        }
    }

    @Override
    @Nullable
    public Drawable cloneDrawable() {
        ProgressBarDrawable copy = new ProgressBarDrawable();
        copy._backgroundColor = this._backgroundColor;
        copy._color = this._color;
        copy._padding = this._padding;
        copy._barWidth = this._barWidth;
        copy.level = this.level;
        copy._radius = this._radius;
        copy.hideWhenZero = this.hideWhenZero;
        copy._isVertical = this._isVertical;
        return copy;
    }

    private final void drawHorizontalBar(Canvas canvas, int level, int color) {
        Rect rect = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
        Rect bounds = rect;
        int length = (bounds.width() - 2 * this._padding) * level / 10000;
        int xpos = bounds.left + this._padding;
        int ypos = bounds.bottom - this._padding - this._barWidth;
        this.rect.set((float)xpos, (float)ypos, (float)(xpos + length), (float)(ypos + this._barWidth));
        this.drawBar(canvas, color);
    }

    private final void drawVerticalBar(Canvas canvas, int level, int color) {
        Rect rect = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
        Rect bounds = rect;
        int length = (bounds.height() - 2 * this._padding) * level / 10000;
        int xpos = bounds.left + this._padding;
        int ypos = bounds.top + this._padding;
        this.rect.set((float)xpos, (float)ypos, (float)(xpos + this._barWidth), (float)(ypos + length));
        this.drawBar(canvas, color);
    }

    private final void drawBar(Canvas canvas, int color) {
        this.paint.setColor(color);
        this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.path.reset();
        this.path.setFillType(Path.FillType.EVEN_ODD);
        this.path.addRoundRect(this.rect, (float)Math.min((double)this._radius, (double)(this._barWidth / 2)), (float)Math.min((double)this._radius, (double)(this._barWidth / 2)), Path.Direction.CW);
        canvas.drawPath(this.path, this.paint);
    }
}

