/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.debug;

import android.util.Log;
import com.facebook.common.references.SharedReference;
import com.facebook.imagepipeline.debug.CloseableReferenceLeakTracker;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class FlipperCloseableReferenceLeakTracker
implements CloseableReferenceLeakTracker {
    @Nullable
    private CloseableReferenceLeakTracker.Listener mListener;

    public void trackCloseableReferenceLeak(SharedReference<Object> reference, @Nullable Throwable stacktrace) {
        if (this.mListener == null) {
            Log.w((String)"FRESCO", (String)"No Flipper listener registered to track CloseableReference leak.");
            return;
        }
        this.mListener.onCloseableReferenceLeak(reference, stacktrace);
    }

    public void setListener(@Nullable CloseableReferenceLeakTracker.Listener listener) {
        this.mListener = listener;
    }

    public boolean isSet() {
        return this.mListener != null;
    }
}

