/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.testing;

import com.facebook.common.memory.PooledByteBuffer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class TrivialBufferPooledByteBuffer
implements PooledByteBuffer {
    private ByteBuffer mBuffer;

    public TrivialBufferPooledByteBuffer(byte[] buf) {
        this.mBuffer = ByteBuffer.allocateDirect(buf.length);
        this.mBuffer.put(buf);
    }

    public int size() {
        return this.isClosed() ? -1 : this.mBuffer.capacity();
    }

    public byte read(int offset) {
        return this.mBuffer.get(offset);
    }

    public int read(int offset, byte[] buffer, int bufferOffset, int length) {
        this.mBuffer.position(offset);
        this.mBuffer.get(buffer, bufferOffset, length);
        return length;
    }

    public long getNativePtr() {
        return 0L;
    }

    @Nullable
    public ByteBuffer getByteBuffer() {
        return this.mBuffer;
    }

    public boolean isClosed() {
        return this.mBuffer == null;
    }

    public void close() {
        this.mBuffer = null;
    }
}

