/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.testing;

import com.facebook.common.time.MonotonicClock;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FakeClock
implements MonotonicClock {
    private final Map<OnTickListener, OnTickListener> otherClocks = new ConcurrentHashMap<OnTickListener, OnTickListener>();
    private final Map<OnTickListener, OnTickListener> listeners = new ConcurrentHashMap<OnTickListener, OnTickListener>();
    private long now;

    public FakeClock() {
        this.now = 100000L;
    }

    public FakeClock(long now) {
        this.now = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementBy(long amountMs) {
        Iterator<OnTickListener> iterator = this;
        synchronized (iterator) {
            this.now += amountMs;
        }
        for (OnTickListener otherClock : this.otherClocks.keySet()) {
            otherClock.onTick();
        }
        for (OnTickListener listener : this.listeners.keySet()) {
            listener.onTick();
        }
    }

    public void incrementInSteps(long tickMs, long totalMs) {
        long start = this.now;
        long end = start + totalMs;
        while (this.now < end) {
            this.incrementBy(Math.min(tickMs, end - this.now));
        }
    }

    public synchronized long now() {
        return this.now;
    }

    public void addOtherClock(OnTickListener otherClock) {
        this.otherClocks.put(otherClock, otherClock);
    }

    public void addListener(OnTickListener listener) {
        this.listeners.put(listener, listener);
    }

    public void removeListener(OnTickListener listener) {
        this.listeners.remove(listener);
    }

    public static interface OnTickListener {
        public void onTick();
    }
}

