/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.testing;

import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.testing.DeltaQueue;
import com.facebook.imagepipeline.testing.FakeClock;

public class ScheduledQueue {
    private final FakeClock clock;
    private final DeltaQueue<Runnable> deltaQueue = new DeltaQueue();
    private long now;
    private boolean isTicking;
    private long tickRemaining;

    public ScheduledQueue(FakeClock clock) {
        this.clock = clock;
        this.now = clock.now();
        clock.addListener(new FakeClock.OnTickListener(){

            @Override
            public void onTick() {
                ScheduledQueue.this.tick();
            }
        });
    }

    private void tick() {
        long newNow = this.clock.now();
        Preconditions.checkState((!this.isTicking ? 1 : 0) != 0);
        this.isTicking = true;
        try {
            this.tickRemaining = newNow - this.now;
            this.now = newNow;
            do {
                this.tickRemaining = this.deltaQueue.tick(this.tickRemaining);
                this.runUntilIdle();
            } while (this.deltaQueue.isNotEmpty() && this.tickRemaining > 0L);
            Preconditions.checkState((boolean)this.isTicking);
        }
        finally {
            this.isTicking = false;
            this.tickRemaining = 0L;
        }
    }

    public void runUntilIdle() {
        while (!this.isIdle()) {
            this.runNextPendingCommand();
        }
    }

    public boolean isIdle() {
        return this.deltaQueue.isEmpty() || this.deltaQueue.delay() > 0L;
    }

    public void runNextPendingCommand() {
        Runnable runnable = this.deltaQueue.pop();
        runnable.run();
    }

    public long getNextPendingCommandDelay() {
        if (this.getPendingCount() == 0) {
            throw new IllegalStateException();
        }
        return this.deltaQueue.delay();
    }

    public void add(Runnable runnable) {
        this.deltaQueue.add(this.tickRemaining, runnable);
    }

    public void add(Runnable runnable, long delayMs) {
        this.deltaQueue.add(this.tickRemaining + delayMs, runnable);
    }

    public boolean remove(Runnable runnable) {
        return this.deltaQueue.remove(runnable);
    }

    public int getPendingCount() {
        return this.deltaQueue.size();
    }
}

