/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.testing;

import com.facebook.imagepipeline.testing.FakeClock;
import com.facebook.imagepipeline.testing.ScheduledQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TestScheduledFuture<V>
implements ScheduledFuture<V> {
    private final FakeClock mFakeClock;
    private final ScheduledQueue mScheduledQueue;
    private final long mScheduledTime;
    private final Runnable mWrap;
    private boolean mIsCanceled;
    private boolean mIsDone;
    private V mResult;
    private Throwable mResultThrowable;

    TestScheduledFuture(FakeClock fakeClock, ScheduledQueue scheduledQueue, long delay, Runnable runnable) {
        this(fakeClock, scheduledQueue, delay, Executors.callable(runnable, null));
    }

    TestScheduledFuture(FakeClock fakeClock, ScheduledQueue scheduledQueue, long delay, final Callable<V> callable) {
        this.mFakeClock = fakeClock;
        this.mScheduledQueue = scheduledQueue;
        this.mScheduledTime = this.mFakeClock.now() + delay;
        this.mWrap = new Runnable(){

            @Override
            public void run() {
                try {
                    TestScheduledFuture.this.mResult = callable.call();
                }
                catch (Throwable t) {
                    TestScheduledFuture.this.mResultThrowable = t;
                }
                TestScheduledFuture.this.mIsDone = true;
            }
        };
        this.mScheduledQueue.add(this.mWrap, delay);
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.mFakeClock.now() - this.mScheduledTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        long other;
        long me = this.getDelay(TimeUnit.MILLISECONDS);
        if (me < (other = delayed.getDelay(TimeUnit.MILLISECONDS))) {
            return -1;
        }
        if (me > other) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean cancel(boolean b) {
        this.mIsCanceled = this.mScheduledQueue.remove(this.mWrap);
        return this.mIsCanceled;
    }

    @Override
    public boolean isCancelled() {
        return this.mIsCanceled;
    }

    @Override
    public boolean isDone() {
        return this.mIsDone;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (!this.mIsDone) {
            throw new IllegalStateException("Not yet done. We don't support blocking in tests");
        }
        if (this.mResultThrowable != null) {
            throw new ExecutionException(this.mResultThrowable);
        }
        return this.mResult;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }
}

