/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageformat;

import com.facebook.common.internal.ByteStreams;
import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.Ints;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Throwables;
import com.facebook.common.webp.WebpSupportStatus;
import com.facebook.imageformat.ImageFormat;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class ImageFormatChecker {
    private static final int SIMPLE_WEBP_HEADER_LENGTH = 20;
    private static final int EXTENDED_WEBP_HEADER_LENGTH = 21;
    private static final byte[] JPEG_HEADER = new byte[]{-1, -40, -1};
    private static final byte[] PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] GIF_HEADER_87A = ImageFormatChecker.asciiBytes("GIF87a");
    private static final byte[] GIF_HEADER_89A = ImageFormatChecker.asciiBytes("GIF89a");
    private static final int GIF_HEADER_LENGTH = 6;
    private static final byte[] BMP_HEADER = ImageFormatChecker.asciiBytes("BM");
    private static final int MAX_HEADER_LENGTH = Ints.max((int[])new int[]{21, 20, JPEG_HEADER.length, PNG_HEADER.length, 6, BMP_HEADER.length});

    private ImageFormatChecker() {
    }

    private static ImageFormat doGetImageFormat(byte[] imageHeaderBytes, int headerSize) {
        Preconditions.checkNotNull((Object)imageHeaderBytes);
        if (WebpSupportStatus.isWebpHeader((byte[])imageHeaderBytes, (int)0, (int)headerSize)) {
            return ImageFormatChecker.getWebpFormat(imageHeaderBytes, headerSize);
        }
        if (ImageFormatChecker.isJpegHeader(imageHeaderBytes, headerSize)) {
            return ImageFormat.JPEG;
        }
        if (ImageFormatChecker.isPngHeader(imageHeaderBytes, headerSize)) {
            return ImageFormat.PNG;
        }
        if (ImageFormatChecker.isGifHeader(imageHeaderBytes, headerSize)) {
            return ImageFormat.GIF;
        }
        if (ImageFormatChecker.isBmpHeader(imageHeaderBytes, headerSize)) {
            return ImageFormat.BMP;
        }
        return ImageFormat.UNKNOWN;
    }

    private static int readHeaderFromStream(InputStream is, byte[] imageHeaderBytes) throws IOException {
        Preconditions.checkNotNull((Object)is);
        Preconditions.checkNotNull((Object)imageHeaderBytes);
        Preconditions.checkArgument((imageHeaderBytes.length >= MAX_HEADER_LENGTH ? 1 : 0) != 0);
        if (is.markSupported()) {
            try {
                is.mark(MAX_HEADER_LENGTH);
                int n = ByteStreams.read((InputStream)is, (byte[])imageHeaderBytes, (int)0, (int)MAX_HEADER_LENGTH);
                return n;
            }
            finally {
                is.reset();
            }
        }
        return ByteStreams.read((InputStream)is, (byte[])imageHeaderBytes, (int)0, (int)MAX_HEADER_LENGTH);
    }

    public static ImageFormat getImageFormat(InputStream is) throws IOException {
        Preconditions.checkNotNull((Object)is);
        byte[] imageHeaderBytes = new byte[MAX_HEADER_LENGTH];
        int headerSize = ImageFormatChecker.readHeaderFromStream(is, imageHeaderBytes);
        return ImageFormatChecker.doGetImageFormat(imageHeaderBytes, headerSize);
    }

    public static ImageFormat getImageFormat_WrapIOException(InputStream is) {
        try {
            return ImageFormatChecker.getImageFormat(is);
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFormat getImageFormat(String filename) {
        ImageFormat imageFormat;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filename);
            imageFormat = ImageFormatChecker.getImageFormat(fileInputStream);
        }
        catch (IOException ioe) {
            ImageFormat imageFormat2;
            try {
                imageFormat2 = ImageFormat.UNKNOWN;
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fileInputStream);
                throw throwable;
            }
            Closeables.closeQuietly((InputStream)fileInputStream);
            return imageFormat2;
        }
        Closeables.closeQuietly((InputStream)fileInputStream);
        return imageFormat;
    }

    private static boolean matchBytePattern(byte[] byteArray, int offset, byte[] pattern) {
        Preconditions.checkNotNull((Object)byteArray);
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        if (pattern.length + offset > byteArray.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (byteArray[i + offset] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] asciiBytes(String value) {
        Preconditions.checkNotNull((Object)value);
        try {
            return value.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("ASCII not found!", uee);
        }
    }

    private static ImageFormat getWebpFormat(byte[] imageHeaderBytes, int headerSize) {
        Preconditions.checkArgument((boolean)WebpSupportStatus.isWebpHeader((byte[])imageHeaderBytes, (int)0, (int)headerSize));
        if (WebpSupportStatus.isSimpleWebpHeader((byte[])imageHeaderBytes, (int)0)) {
            return ImageFormat.WEBP_SIMPLE;
        }
        if (WebpSupportStatus.isLosslessWebpHeader((byte[])imageHeaderBytes, (int)0)) {
            return ImageFormat.WEBP_LOSSLESS;
        }
        if (WebpSupportStatus.isExtendedWebpHeader((byte[])imageHeaderBytes, (int)0, (int)headerSize)) {
            if (WebpSupportStatus.isAnimatedWebpHeader((byte[])imageHeaderBytes, (int)0)) {
                return ImageFormat.WEBP_ANIMATED;
            }
            if (WebpSupportStatus.isExtendedWebpHeaderWithAlpha((byte[])imageHeaderBytes, (int)0)) {
                return ImageFormat.WEBP_EXTENDED_WITH_ALPHA;
            }
            return ImageFormat.WEBP_EXTENDED;
        }
        return ImageFormat.UNKNOWN;
    }

    private static boolean isJpegHeader(byte[] imageHeaderBytes, int headerSize) {
        return headerSize >= JPEG_HEADER.length && ImageFormatChecker.matchBytePattern(imageHeaderBytes, 0, JPEG_HEADER);
    }

    private static boolean isPngHeader(byte[] imageHeaderBytes, int headerSize) {
        return headerSize >= PNG_HEADER.length && ImageFormatChecker.matchBytePattern(imageHeaderBytes, 0, PNG_HEADER);
    }

    private static boolean isGifHeader(byte[] imageHeaderBytes, int headerSize) {
        if (headerSize < 6) {
            return false;
        }
        return ImageFormatChecker.matchBytePattern(imageHeaderBytes, 0, GIF_HEADER_87A) || ImageFormatChecker.matchBytePattern(imageHeaderBytes, 0, GIF_HEADER_89A);
    }

    private static boolean isBmpHeader(byte[] imageHeaderBytes, int headerSize) {
        if (headerSize < BMP_HEADER.length) {
            return false;
        }
        return ImageFormatChecker.matchBytePattern(imageHeaderBytes, 0, BMP_HEADER);
    }
}

