/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.disk;

import com.facebook.binaryresource.BinaryResource;
import com.facebook.cache.common.WriterCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface DiskStorage {
    public boolean isEnabled();

    public BinaryResource getResource(String var1, Object var2) throws IOException;

    public boolean contains(String var1, Object var2) throws IOException;

    public boolean touch(String var1, Object var2) throws IOException;

    public void purgeUnexpectedResources();

    public Inserter insert(String var1, Object var2) throws IOException;

    public Collection<Entry> getEntries() throws IOException;

    public long remove(Entry var1) throws IOException;

    public long remove(String var1) throws IOException;

    public void clearAll() throws IOException;

    public DiskDumpInfo getDumpInfo() throws IOException;

    public String getStorageName();

    public static interface Inserter {
        public void writeData(WriterCallback var1, Object var2) throws IOException;

        public BinaryResource commit(Object var1) throws IOException;

        public boolean cleanUp();
    }

    public static interface Entry {
        public String getId();

        public long getTimestamp();

        public long getSize();

        public BinaryResource getResource();
    }

    public static class DiskDumpInfo {
        public List<DiskDumpInfoEntry> entries = new ArrayList<DiskDumpInfoEntry>();
        public Map<String, Integer> typeCounts = new HashMap<String, Integer>();
    }

    public static class DiskDumpInfoEntry {
        public final String path;
        public final String type;
        public final float size;
        public final String firstBits;

        protected DiskDumpInfoEntry(String path, String type, float size, String firstBits) {
            this.path = path;
            this.type = type;
            this.size = size;
            this.firstBits = firstBits;
        }
    }
}

