/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.common;

import com.facebook.imagepipeline.common.ImageDecodeOptionsBuilder;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ImageDecodeOptions {
    private static final ImageDecodeOptions DEFAULTS = ImageDecodeOptions.newBuilder().build();
    public final int minDecodeIntervalMs;
    public final int backgroundColor;
    public final boolean forceOldAnimationCode;
    public final boolean decodePreviewFrame;
    public final boolean useLastFrameForPreview;
    public final boolean decodeAllFrames;
    public final boolean forceStaticImage;

    public ImageDecodeOptions(ImageDecodeOptionsBuilder b) {
        this.minDecodeIntervalMs = b.getMinDecodeIntervalMs();
        this.backgroundColor = b.getBackgroundColor();
        this.forceOldAnimationCode = b.getForceOldAnimationCode();
        this.decodePreviewFrame = b.getDecodePreviewFrame();
        this.useLastFrameForPreview = b.getUseLastFrameForPreview();
        this.decodeAllFrames = b.getDecodeAllFrames();
        this.forceStaticImage = b.getForceStaticImage();
    }

    public static ImageDecodeOptions defaults() {
        return DEFAULTS;
    }

    public static ImageDecodeOptionsBuilder newBuilder() {
        return new ImageDecodeOptionsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageDecodeOptions that = (ImageDecodeOptions)o;
        if (this.backgroundColor != that.backgroundColor) {
            return false;
        }
        if (this.forceOldAnimationCode != that.forceOldAnimationCode) {
            return false;
        }
        if (this.decodePreviewFrame != that.decodePreviewFrame) {
            return false;
        }
        if (this.useLastFrameForPreview != that.useLastFrameForPreview) {
            return false;
        }
        if (this.decodeAllFrames != that.decodeAllFrames) {
            return false;
        }
        return this.forceStaticImage == that.forceStaticImage;
    }

    public int hashCode() {
        int result = this.backgroundColor;
        result = 31 * result + (this.forceOldAnimationCode ? 1 : 0);
        return result;
    }

    public String toString() {
        return String.format((Locale)null, "%d-%d-%b-%b-%b-%b-%b", this.minDecodeIntervalMs, this.backgroundColor, this.forceOldAnimationCode, this.decodePreviewFrame, this.useLastFrameForPreview, this.decodeAllFrames, this.forceStaticImage);
    }
}

